/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyAllVariantsProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorImpl;

public final class GroovyResolverProcessorBuilder {
    private boolean myIncomplete = false;
    private boolean myAllVariants = false;
    private GrExpression myUpToArgument = null;
    private boolean myForceRValue = false;

    @NotNull
    public GroovyResolverProcessor build(GrReferenceExpression ref) {
        EnumSet<GroovyResolveKind> kinds;
        EnumSet<GroovyResolveKind> enumSet = kinds = this.myIncomplete ? EnumSet.allOf(GroovyResolveKind.class) : GroovyResolverProcessorBuilder.computeKinds(ref);
        if (this.myAllVariants) {
            GroovyAllVariantsProcessor groovyAllVariantsProcessor = new GroovyAllVariantsProcessor(ref, kinds, this.myUpToArgument);
            if (groovyAllVariantsProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "build"));
            }
            return groovyAllVariantsProcessor;
        }
        GroovyResolverProcessorImpl groovyResolverProcessorImpl = new GroovyResolverProcessorImpl(ref, kinds, this.myForceRValue);
        if (groovyResolverProcessorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "build"));
        }
        return groovyResolverProcessorImpl;
    }

    @NotNull
    public static GroovyResolverProcessorBuilder builder() {
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = new GroovyResolverProcessorBuilder();
        if (groovyResolverProcessorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "builder"));
        }
        return groovyResolverProcessorBuilder;
    }

    public GroovyResolverProcessorBuilder setIncomplete(boolean incomplete) {
        this.myIncomplete = incomplete;
        return this;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setAllVariants(boolean allVariants) {
        this.myAllVariants = allVariants;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "setAllVariants"));
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setUpToArgument(GrExpression upToArgument) {
        this.myUpToArgument = upToArgument;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "setUpToArgument"));
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setForceRValue(boolean forceRValue) {
        this.myForceRValue = forceRValue;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "setForceRValue"));
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    private static EnumSet<GroovyResolveKind> computeKinds(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "computeKinds"));
        }
        if (ref.hasAt()) {
            EnumSet<GroovyResolveKind> enumSet = EnumSet.of(GroovyResolveKind.FIELD);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "computeKinds"));
            }
            return enumSet;
        }
        if (ref.hasMemberPointer()) {
            EnumSet<GroovyResolveKind> enumSet = EnumSet.of(GroovyResolveKind.METHOD);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "computeKinds"));
            }
            return enumSet;
        }
        EnumSet<GroovyResolveKind> result = EnumSet.allOf(GroovyResolveKind.class);
        if (!ResolveUtil.canBeClass(ref)) {
            result.remove((Object)GroovyResolveKind.CLASS);
        }
        if (!ResolveUtil.canBePackage(ref)) {
            result.remove((Object)GroovyResolveKind.PACKAGE);
        }
        if (ref.isQualified()) {
            result.remove((Object)GroovyResolveKind.BINDING);
        }
        if (!(ref.getParent() instanceof GrMethodCall)) {
            result.remove((Object)GroovyResolveKind.METHOD);
        }
        EnumSet<GroovyResolveKind> enumSet = result;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder", "computeKinds"));
        }
        return enumSet;
    }
}

