/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

class GroovyResolverProcessorImpl
extends GroovyResolverProcessor
implements GrMethodComparator.Context {
    private final boolean myIsPartOfFqn;

    GroovyResolverProcessorImpl(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "<init>"));
        }
        super(ref, kinds, null, forceRValue);
        this.myIsPartOfFqn = ResolveUtil.isPartOfFQN(ref);
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getCandidates() {
        PsiElement element;
        GroovyResolveResult candidate;
        List<GroovyResolveResult> candidates;
        if (this.myAcceptableKinds.contains((Object)GroovyResolveKind.PACKAGE) && this.myIsPartOfFqn && !(candidates = this.getCandidates(GroovyResolveKind.PACKAGE)).isEmpty()) {
            candidate = candidates.get(0);
            element = candidate.getElement();
            assert (element instanceof PsiPackage);
            GrReferenceExpressionImpl topRef = GroovyResolverProcessorImpl.getContextReferenceExpression(this.myRef);
            if (topRef != null) {
                String fqn = topRef.getTextSkipWhiteSpaceAndComments();
                if (JavaPsiFacade.getInstance((Project)this.myRef.getProject()).findClass(fqn, this.myRef.getResolveScope()) != null) {
                    List<GroovyResolveResult> list = candidates;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
                    }
                    return list;
                }
            }
        }
        if (!(candidates = this.getCandidates(GroovyResolveKind.VARIABLE)).isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.METHOD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> results2 = this.filterMethodCandidates(candidates);
            List<GroovyResolveResult> list = this.myRef.hasMemberPointer() ? GroovyResolverProcessorImpl.collapseReflectedMethods(results2) : results2;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.ENUM_CONST);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.FIELD);
        if (!candidates.isEmpty()) {
            assert (candidates.size() == 1);
            candidate = candidates.get(0);
            element = candidate.getElement();
            if (element instanceof PsiField) {
                PsiClass containingClass = ((PsiField)element).getContainingClass();
                if (containingClass != null && PsiUtil.getContextClass(this.myRef) == containingClass) {
                    List<GroovyResolveResult> list = candidates;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
                    }
                    return list;
                }
            } else if (!(element instanceof GrBindingVariable)) {
                List<GroovyResolveResult> list = candidates;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
                }
                return list;
            }
        }
        if (this.myIsPartOfFqn && !(candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS)).isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates.size() <= 1 ? candidates : ContainerUtil.newSmartList((Object)candidates.get(0));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.FIELD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.BINDING);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return list;
        }
        for (GroovyResolveKind kind : this.myAcceptableKinds) {
            Collection results3 = this.myInapplicableCandidates.get((Object)kind);
            if (results3.isEmpty()) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])ResolveUtil.filterSameSignatureCandidates(this.filterCorrectParameterCount(results3)));
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
            }
            return arrayList;
        }
        List<GroovyResolveResult> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getCandidates"));
        }
        return list;
    }

    private static GrReferenceExpressionImpl getContextReferenceExpression(GrReferenceExpression ref) {
        PsiElement firstNonReferenceExprParent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{GrReferenceExpressionImpl.class});
        return (GrReferenceExpressionImpl)PsiTreeUtil.findFirstParent((PsiElement)ref, parent -> parent.getParent() == firstNonReferenceExprParent && parent instanceof GrReferenceExpressionImpl);
    }

    private List<GroovyResolveResult> filterCorrectParameterCount(Collection<GroovyResolveResult> candidates) {
        PsiType[] argumentTypes = (PsiType[])this.myArgumentTypes.getValue();
        if (argumentTypes == null) {
            return ContainerUtil.newArrayList(candidates);
        }
        List result = ContainerUtil.newSmartList();
        for (GroovyResolveResult candidate : candidates) {
            if (candidate instanceof GroovyMethodResult) {
                if (((GroovyMethodResult)candidate).getElement().getParameterList().getParametersCount() != argumentTypes.length) continue;
                result.add(candidate);
                continue;
            }
            result.add(candidate);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return ContainerUtil.newArrayList(candidates);
    }

    private List<GroovyResolveResult> filterMethodCandidates(List<GroovyResolveResult> candidates) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList results2 = ContainerUtil.newArrayList();
        Iterator<GroovyResolveResult> itr = candidates.iterator();
        results2.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyResolveResult resolveResult = itr.next();
            if (resolveResult instanceof GroovyMethodResult) {
                Iterator iterator = results2.iterator();
                while (iterator.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator.next();
                    if (!(otherResolveResult instanceof GroovyMethodResult)) continue;
                    int res = GrMethodComparator.compareMethods((GroovyMethodResult)resolveResult, (GroovyMethodResult)otherResolveResult, this);
                    if (res > 0) continue block0;
                    if (res >= 0) continue;
                    iterator.remove();
                }
            }
            results2.add(resolveResult);
        }
        return results2;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return (PsiType[])this.myArgumentTypes.getValue();
    }

    @Override
    @Nullable
    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    @Override
    @Nullable
    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        GrReferenceExpression grReferenceExpression = this.myRef;
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl", "getPlace"));
        }
        return grReferenceExpression;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    private static List<GroovyResolveResult> collapseReflectedMethods(Collection<GroovyResolveResult> candidates) {
        HashSet visited = ContainerUtil.newHashSet();
        ArrayList collapsed = ContainerUtil.newArrayList();
        for (GroovyResolveResult result : candidates) {
            PsiElement element = result.getElement();
            if (element instanceof GrReflectedMethod) {
                GrMethod baseMethod = ((GrReflectedMethod)element).getBaseMethod();
                if (!visited.add(baseMethod)) continue;
                collapsed.add(PsiImplUtil.reflectedToBase(result, baseMethod, (GrReflectedMethod)element));
                continue;
            }
            collapsed.add(result);
        }
        return collapsed;
    }
}

