/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.psi.PsiFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GroovyScriptUtil {
    public static final GroovyRunnableScriptType DEFAULT_TYPE = new GroovyRunnableScriptType("default"){

        @Override
        public boolean shouldBeCompiled(GroovyFile script) {
            return true;
        }

        @Override
        @NotNull
        public Icon getScriptIcon() {
            Icon icon = JetgroovyIcons.Groovy.GroovyFile;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil$1", "getScriptIcon"));
            }
            return icon;
        }

        @Override
        public GroovyScriptRunner getRunner() {
            return new DefaultGroovyScriptRunner();
        }
    };

    public static boolean isSpecificScriptFile(@NotNull PsiFile file, GroovyScriptType scriptType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil", "isSpecificScriptFile"));
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)file, scriptType);
    }

    public static boolean isSpecificScriptFile(@NotNull GroovyFile script, GroovyScriptType scriptType) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil", "isSpecificScriptFile"));
        }
        assert (script.isScript());
        if (scriptType == DEFAULT_TYPE) {
            return GroovyScriptUtil.getScriptType(script) == DEFAULT_TYPE;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (detector.getScriptType() != scriptType || !detector.isSpecificScriptFile(script)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GroovyRunnableScriptType getScriptType(@NotNull GroovyFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil", "getScriptType"));
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            GroovyRunnableScriptType groovyRunnableScriptType = (GroovyRunnableScriptType)detector.getScriptType();
            if (groovyRunnableScriptType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil", "getScriptType"));
            }
            return groovyRunnableScriptType;
        }
        GroovyRunnableScriptType groovyRunnableScriptType = DEFAULT_TYPE;
        if (groovyRunnableScriptType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptUtil", "getScriptType"));
        }
        return groovyRunnableScriptType;
    }
}

