/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GrFileIndexUtil {
    public static boolean isGroovySourceFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/util/GrFileIndexUtil", "isGroovySourceFile"));
        }
        return file instanceof GroovyFileBase && GrFileIndexUtil.isGroovySourceFile((GroovyFileBase)file);
    }

    public static boolean isGroovySourceFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/util/GrFileIndexUtil", "isGroovySourceFile"));
        }
        return GrFileIndexUtil.isInSourceFiles(file.getVirtualFile(), file.getProject());
    }

    private static boolean isInSourceFiles(@Nullable VirtualFile file, @NotNull Project project) {
        FileIndexFacade index;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/util/GrFileIndexUtil", "isInSourceFiles"));
        }
        return file != null && !(file instanceof LightVirtualFile) && ((index = FileIndexFacade.getInstance((Project)project)).isInSource(file) || index.isInLibraryClasses(file));
    }

    public static boolean hasNameInFile(@NotNull PsiFile file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/util/GrFileIndexUtil", "hasNameInFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/util/GrFileIndexUtil", "hasNameInFile"));
        }
        if (file.getVirtualFile() == null || DumbService.isDumb((Project)file.getProject())) {
            return StringUtil.contains((CharSequence)file.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)new IdIndexEntry(name, true), scope).isEmpty();
    }
}

