/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.ide.DataManager;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.jetbrains.annotations.NotNull;

public class RenameVariableFix
extends AbstractFix {
    private final XsltElement myElement;
    private final String myPlace;

    public RenameVariableFix(XmlTag tag, String place) {
        this.myElement = XsltElementFactory.getInstance().wrapElement(tag, XsltElement.class);
        this.myPlace = place;
    }

    @NotNull
    public String getText() {
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(this.myElement.getLanguage())).getType((PsiElement)this.myElement);
        String string = "Rename " + this.myPlace + " " + StringUtil.capitalize((String)type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/RenameVariableFix", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/RenameVariableFix", "isAvailableImpl"));
        }
        return this.myElement.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/RenameVariableFix", "invoke"));
        }
        RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{this.myElement}, DataManager.getInstance().getDataContext());
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

