/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u00032\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u00060\u0005B+\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J#\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u00062\u0006\u0010\u001b\u001a\u00020\u0012H\u0096\u0002J\u001c\u0010\u001c\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u0018\u00010\u0006H\u0016J$\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/AggregatedReplStateHistory;", "T1", "T2", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Lkotlin/Pair;", "Lkotlin/collections/AbstractList;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "history1", "history2", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "getHistory1", "()Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "getHistory2", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "size", "", "getSize", "()I", "assertSameId", "", "r1", "r2", "assertSameSize", "get", "index", "pop", "push", "id", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "item", "resetTo", "", "compiler-deps"})
public class AggregatedReplStateHistory<T1, T2>
extends AbstractList<ReplHistoryRecord<? extends Pair<? extends T1, ? extends T2>>>
implements IReplStageHistory<Pair<? extends T1, ? extends T2>> {
    @NotNull
    private final IReplStageHistory<T1> history1;
    @NotNull
    private final IReplStageHistory<T2> history2;
    @NotNull
    private final ReentrantReadWriteLock lock;

    @Override
    public int getSize() {
        int n = this.history1.size();
        int n2 = this.history2.size();
        return Math.min(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(@NotNull ILineId id, @NotNull Pair<? extends T1, ? extends T2> item) {
        int n;
        if (id == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(1);
        }
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(item, "item");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            this.history1.push(id, item.getFirst());
            this.history2.push(id, item.getSecond());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplHistoryRecord<Pair<T1, T2>> get(int index) {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            this.assertSameSize();
            ReplHistoryRecord r1 = (ReplHistoryRecord)this.history1.get(index);
            ReplHistoryRecord r2 = (ReplHistoryRecord)this.history2.get(index);
            this.assertSameId(r1, r2);
            ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord2 = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
            replHistoryRecord = replHistoryRecord2;
        }
        finally {
            readLock.unlock();
        }
        if (replHistoryRecord == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(2);
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> pop() {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            ReplHistoryRecord<T1> r1 = this.history1.pop();
            ReplHistoryRecord<T2> r2 = this.history2.pop();
            if (r1 == null && r2 == null) {
                ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord2 = null;
                return replHistoryRecord2;
            }
            if (r1 == null || r2 == null) {
                throw (Throwable)new IllegalStateException("Aggregated history mismatch: " + r1 + " vs " + r2);
            }
            this.assertSameId(r1, r2);
            replHistoryRecord = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
        }
        finally {
            n = 0;
            int r1 = n3 - 1;
            if (n <= r1) {
                do {
                    int r2 = ++n;
                    readLock.lock();
                } while (n != r1);
            }
            writeLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        List<ILineId> list;
        int n;
        if (id == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(3);
        }
        Intrinsics.checkParameterIsNotNull(id, "id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            List<ILineId> i1 = CollectionsKt.toList(this.history1.resetTo(id));
            List<ILineId> i2 = CollectionsKt.toList(this.history2.resetTo(id));
            if (Intrinsics.areEqual(i1, i2) ^ true) {
                throw (Throwable)new IllegalStateException("Aggregated history resetted lines mismatch: " + i1 + " != " + i2);
            }
            list = i1;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        Iterable iterable = list;
        if (iterable == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    private final void assertSameSize() {
        if (this.history1.size() != this.history2.size()) {
            throw (Throwable)new IllegalStateException("Aggregated history sizes mismatch: " + this.history1.size() + " != " + this.history2.size());
        }
    }

    private final void assertSameId(ReplHistoryRecord<? extends T1> r1, ReplHistoryRecord<? extends T2> r2) {
        if (Intrinsics.areEqual(r1.getId(), r2.getId()) ^ true) {
            throw (Throwable)new IllegalStateException("Aggregated history mismatch: " + r1.getId() + " != " + r2.getId());
        }
    }

    @NotNull
    public final IReplStageHistory<T1> getHistory1() {
        IReplStageHistory<T1> iReplStageHistory = this.history1;
        if (iReplStageHistory == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(5);
        }
        return iReplStageHistory;
    }

    @NotNull
    public final IReplStageHistory<T2> getHistory2() {
        IReplStageHistory<T2> iReplStageHistory = this.history2;
        if (iReplStageHistory == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(6);
        }
        return iReplStageHistory;
    }

    @Override
    @NotNull
    public ReentrantReadWriteLock getLock() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        if (reentrantReadWriteLock == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(7);
        }
        return reentrantReadWriteLock;
    }

    public AggregatedReplStateHistory(@NotNull IReplStageHistory<T1> history1, @NotNull IReplStageHistory<T2> history2, @NotNull ReentrantReadWriteLock lock) {
        if (history1 == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(8);
        }
        if (history2 == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(9);
        }
        if (lock == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(10);
        }
        Intrinsics.checkParameterIsNotNull(history1, "history1");
        Intrinsics.checkParameterIsNotNull(history2, "history2");
        Intrinsics.checkParameterIsNotNull(lock, "lock");
        this.history1 = history1;
        this.history2 = history2;
        this.lock = lock;
    }

    public /* synthetic */ AggregatedReplStateHistory(IReplStageHistory iReplStageHistory, IReplStageHistory iReplStageHistory2, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(iReplStageHistory, iReplStageHistory2, reentrantReadWriteLock);
    }

    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> peek() {
        return IReplStageHistory.DefaultImpls.peek(this);
    }

    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> verifiedPop(@NotNull ILineId id) {
        if (id == null) {
            AggregatedReplStateHistory.$$$reportNull$$$0(11);
        }
        Intrinsics.checkParameterIsNotNull(id, "id");
        return IReplStageHistory.DefaultImpls.verifiedPop(this, id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/repl/AggregatedReplStateHistory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/repl/AggregatedReplStateHistory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resetTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetTo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "verifiedPop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

