/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;

public abstract class CvsOperation {
    private static final NotNullLazyValue<Map<String, String>> ourCvsEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

        @NotNull
        protected Map<String, String> compute() {
            String[] toCvs;
            HashMap<String, String> cvsEnv = new HashMap<String, String>();
            Map knownToCvs = EnvironmentUtil.getEnvironmentMap();
            for (String name : toCvs = new String[]{"CVSIGNORE", "CVSWRAPPERS", "CVSREAD", "CVSREADONLYFS", "CVSUMASK", "CVSROOT", "CVSEDITOR", "EDITOR", "VISUAL", "PATH", "HOME", "HOMEPATH", "HOMEDRIVE", "CVS_RSH", "CVS_SERVER", "CVS_PASSFILE", "CVS_CLIENT_PORT", "CVS_PROXY_PORT", "CVS_RCMD_PORT", "CVS_CLIENT_LOG", "CVS_SERVER_SLEEP", "CVS_IGNORE_REMOTE_ROOT", "CVS_LOCAL_BRANCH_NUM", "COMSPEC", "TMPDIR", "CVS_PID", "COMSPEC", "CVS_VERIFY_TEMPLATE", "CVS_NOBASES", "CVS_SIGN_COMMITS", "CVS_VERIFY_CHECKOUTS"}) {
                String value = (String)knownToCvs.get(name);
                if (value == null) continue;
                cvsEnv.put(name, value);
            }
            HashMap<String, String> hashMap = cvsEnv;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/cvsoperations/common/CvsOperation$1", "compute"));
            }
            return hashMap;
        }
    };
    private final Collection<Runnable> myFinishActions = new ArrayList<Runnable>();

    public abstract void execute(CvsExecutionEnvironment var1, boolean var2) throws VcsException, CommandAbortedException;

    public abstract void appendSelfCvsRootProvider(@NotNull Collection<CvsEnvironment> var1) throws CannotFindCvsRootException;

    public void addFinishAction(Runnable action) {
        this.myFinishActions.add(action);
    }

    public void executeFinishActions() {
        this.myFinishActions.forEach(Runnable::run);
    }

    protected void modifyOptions(GlobalOptions options) {
        options.setUseGzip(CvsApplicationLevelConfiguration.getInstance().USE_GZIP);
        if (CvsApplicationLevelConfiguration.getInstance().SEND_ENVIRONMENT_VARIABLES_TO_SERVER) {
            options.setEnvVariables((Map)ourCvsEnvironment.getValue());
        }
    }

    public int getFilesToProcessCount() {
        return -1;
    }

    public static int calculateFilesIn(File file) {
        if (!file.isDirectory()) {
            return 1;
        }
        File[] subFiles = file.listFiles();
        if (subFiles == null) {
            return 0;
        }
        return Arrays.stream(subFiles).mapToInt(CvsOperation::calculateFilesIn).sum();
    }

    public abstract String getLastProcessedCvsRoot();

    public boolean runInReadThread() {
        return true;
    }
}

