/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.history;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparableVcsRevisionOnOperation
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.history.ComparableVcsRevisionOnOperation");
    private final GetFileContentOperation myOperation;
    private final Project myProject;

    public ComparableVcsRevisionOnOperation(GetFileContentOperation operation, Project project) {
        this.myOperation = operation;
        this.myProject = project;
    }

    public boolean isDeleted() {
        return this.myOperation.isDeleted();
    }

    public byte[] getContent() throws IOException, VcsException {
        LOG.assertTrue(this.myOperation.isLoaded());
        return this.myOperation.getFileBytes();
    }

    public byte[] loadContent() throws IOException, VcsException {
        if (!this.myOperation.isLoaded()) {
            CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
            executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"operation.name.load.file", (Object[])new Object[0]), this.myOperation), CvsOperationExecutorCallback.EMPTY);
            CvsResult result = executor.getResult();
            if (result.isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (result.hasErrors()) {
                throw result.composeError();
            }
        }
        return this.getContent();
    }

    public boolean fileNotFound() {
        return this.myOperation.fileNotFound();
    }

    public CvsRevisionNumber getRevision() {
        return this.myOperation.getRevisionNumber();
    }

    public boolean isLoaded() {
        return this.myOperation.isLoaded();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        CvsRevisionNumber cvsRevisionNumber = this.getRevision();
        if (cvsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/history/ComparableVcsRevisionOnOperation", "getRevisionNumber"));
        }
        return cvsRevisionNumber;
    }

    public Date getRevisionDate() {
        return null;
    }

    public String getAuthor() {
        return null;
    }

    public String getCommitMessage() {
        return null;
    }

    public String getBranchName() {
        return null;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }
}

