/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.AbstractTestNGPatternConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTestNGInClassConfigurationProducer
extends TestNGConfigurationProducer {
    protected AbstractTestNGInClassConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    private static boolean isTestNGClass(PsiClass psiClass) {
        return psiClass != null && TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
    }

    public void onFirstRun(final ConfigurationFromContext configuration, ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        if (performRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "performRunnable", "com/theoryinpractice/testng/configuration/AbstractTestNGInClassConfigurationProducer", "onFirstRun"));
        }
        final PsiElement psiElement = configuration.getSourceElement();
        if (psiElement instanceof PsiMethod || psiElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (psiElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)psiElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)psiElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ((TestNGConfiguration)configuration.getConfiguration()).bePatternConfiguration(classes, method);
                    super.runForClasses(classes, method, context, performRunnable);
                }

                protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    if (psiElement instanceof PsiMethod) {
                        Project project = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project, psiMethod, PsiLocation.fromPsiElement((PsiElement)aClass));
                        ((TestNGConfiguration)configuration.getConfiguration()).setMethodConfiguration((Location<PsiMethod>)methodLocation);
                    } else {
                        ((TestNGConfiguration)configuration.getConfiguration()).setClassConfiguration(aClass);
                    }
                    super.runForClass(aClass, psiMethod, context, performRunnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(fromContext, performRunnable, psiMethod, containingClass, aClass -> aClass.hasModifierProperty("abstract") && TestNGUtil.hasTest((PsiModifierListOwner)aClass))) {
                return;
            }
        }
        super.onFirstRun(configuration, fromContext, performRunnable);
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((AbstractTestNGPatternConfigurationProducer)RunConfigurationProducer.getInstance(AbstractTestNGPatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        AbstractTestNGInClassConfigurationProducer.setupConfigurationParamName(configuration, contextLocation);
        PsiClass psiClass = null;
        for (PsiElement element = context.getPsiLocation(); element != null; element = element.getParent()) {
            PsiClass[] classes;
            if (element instanceof PsiClass && AbstractTestNGInClassConfigurationProducer.isTestNGClass((PsiClass)element)) {
                psiClass = (PsiClass)element;
                break;
            }
            if (element instanceof PsiMember) {
                psiClass = ((PsiMember)element).getContainingClass();
                if (!AbstractTestNGInClassConfigurationProducer.isTestNGClass(psiClass)) continue;
                break;
            }
            if (!(element instanceof PsiClassOwner) || (classes = ((PsiClassOwner)element).getClasses()).length != 1) continue;
            psiClass = classes[0];
            break;
        }
        if (!AbstractTestNGInClassConfigurationProducer.isTestNGClass(psiClass)) {
            return false;
        }
        PsiClass psiElement = psiClass;
        Project project = context.getProject();
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.setClassConfiguration(psiClass);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiLocation(), PsiMethod.class, (boolean)false);
        while (method != null) {
            if (TestNGUtil.hasTest((PsiModifierListOwner)method)) {
                configuration.setMethodConfiguration((Location<PsiMethod>)PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
                psiElement = method;
            }
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class);
        }
        configuration.restoreOriginalModule(originalModule);
        settings.setName(configuration.getName());
        sourceElement.set((Object)psiElement);
        return true;
    }
}

