/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ModelClass;
import java.util.List;

public abstract class ModelMethod {
    public abstract ModelClass getDeclaringClass();

    public abstract ModelClass[] getParameterTypes();

    public abstract String getName();

    public abstract ModelClass getReturnType(List<ModelClass> var1);

    public abstract boolean isVoid();

    public abstract boolean isPublic();

    public abstract boolean isProtected();

    public abstract boolean isStatic();

    public abstract boolean isAbstract();

    public abstract boolean isBindable();

    public abstract int getMinApi();

    public abstract String getJniDescription();

    public abstract boolean isVarArgs();

    public boolean acceptsArguments(List<ModelClass> args) {
        boolean isVarArgs = this.isVarArgs();
        ModelClass[] parameterTypes = this.getParameterTypes();
        if (!isVarArgs && args.size() != parameterTypes.length || isVarArgs && args.size() < parameterTypes.length - 1) {
            return false;
        }
        boolean parametersMatch = true;
        for (int i = 0; i < args.size(); ++i) {
            ModelClass parameterType = this.getParameter(i, parameterTypes);
            ModelClass arg = args.get(i);
            if (parameterType.isIncomplete()) {
                parameterType = parameterType.erasure();
            }
            if (parameterType.isAssignableFrom(arg) || ModelMethod.isImplicitConversion(arg, parameterType)) continue;
            parametersMatch = false;
            break;
        }
        return parametersMatch;
    }

    public boolean isBetterArgMatchThan(ModelMethod other, List<ModelClass> args) {
        ModelClass[] parameterTypes = this.getParameterTypes();
        ModelClass[] otherParameterTypes = other.getParameterTypes();
        for (int i = 0; i < args.size(); ++i) {
            int diff;
            ModelClass thatParameter;
            ModelClass arg = args.get(i);
            ModelClass thisParameter = this.getParameter(i, parameterTypes);
            if (thisParameter.equals(thatParameter = other.getParameter(i, otherParameterTypes)) || (diff = ModelMethod.compareParameter(arg, thisParameter, thatParameter)) == 0) continue;
            return diff < 0;
        }
        return false;
    }

    public ModelClass getReturnType() {
        return this.getReturnType(null);
    }

    private ModelClass getParameter(int index, ModelClass[] parameterTypes) {
        int normalParamCount;
        int n = normalParamCount = this.isVarArgs() ? parameterTypes.length - 1 : parameterTypes.length;
        if (index < normalParamCount) {
            return parameterTypes[index];
        }
        return parameterTypes[parameterTypes.length - 1].getComponentType();
    }

    private static int compareParameter(ModelClass arg, ModelClass thisParameter, ModelClass thatParameter) {
        if (thatParameter.equals(arg)) {
            return 1;
        }
        if (thisParameter.equals(arg)) {
            return -1;
        }
        if (ModelMethod.isBoxingConversion(thatParameter, arg)) {
            return 1;
        }
        if (ModelMethod.isBoxingConversion(thisParameter, arg)) {
            return -1;
        }
        int argConversionLevel = ModelMethod.getImplicitConversionLevel(arg);
        if (argConversionLevel != -1) {
            int oldConversionLevel = ModelMethod.getImplicitConversionLevel(thatParameter);
            int newConversionLevel = ModelMethod.getImplicitConversionLevel(thisParameter);
            if (newConversionLevel != -1 && (oldConversionLevel == -1 || newConversionLevel < oldConversionLevel)) {
                return -1;
            }
            if (oldConversionLevel != -1) {
                return 1;
            }
        }
        if (thatParameter.isAssignableFrom(thisParameter)) {
            return -1;
        }
        return 0;
    }

    public static boolean isBoxingConversion(ModelClass class1, ModelClass class2) {
        if (class1.isPrimitive() != class2.isPrimitive()) {
            return class1.box().equals(class2.box());
        }
        return false;
    }

    public static int getImplicitConversionLevel(ModelClass primitive) {
        if (primitive == null) {
            return -1;
        }
        if (primitive.isByte()) {
            return 0;
        }
        if (primitive.isChar()) {
            return 1;
        }
        if (primitive.isShort()) {
            return 2;
        }
        if (primitive.isInt()) {
            return 3;
        }
        if (primitive.isLong()) {
            return 4;
        }
        if (primitive.isFloat()) {
            return 5;
        }
        if (primitive.isDouble()) {
            return 6;
        }
        return -1;
    }

    public static boolean isImplicitConversion(ModelClass from, ModelClass to) {
        if (from != null && to != null && from.isPrimitive() && to.isPrimitive()) {
            int toConversionLevel;
            if (from.isBoolean() || to.isBoolean() || to.isChar()) {
                return false;
            }
            int fromConversionLevel = ModelMethod.getImplicitConversionLevel(from);
            return fromConversionLevel < (toConversionLevel = ModelMethod.getImplicitConversionLevel(to));
        }
        return false;
    }
}

