/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgAnnotateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.provider.HgHistoryProvider;
import org.zmlx.hg4idea.provider.annotate.HgAnnotation;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;
import org.zmlx.hg4idea.util.HgUtil;

public class HgAnnotationProvider
implements AnnotationProviderEx {
    @NotNull
    private final Project myProject;

    public HgAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        FileAnnotation fileAnnotation = this.annotate(file, null);
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, VcsFileRevision revision) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)file.getPath()));
        if (vcsRoot == null) {
            throw new VcsException("vcs root is null for " + file);
        }
        HgRevisionNumber revisionNumber = revision != null ? (HgRevisionNumber)revision.getRevisionNumber() : null;
        HgFile hgFile = new HgFile(vcsRoot, VfsUtilCore.virtualToIoFile((VirtualFile)file));
        HgFile fileToAnnotate = revision instanceof HgFileRevision ? HgUtil.getFileNameInTargetRevision(this.myProject, revisionNumber, hgFile) : new HgFile(vcsRoot, HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject)));
        List<HgAnnotationLine> annotationResult = new HgAnnotateCommand(this.myProject).execute(fileToAnnotate, revisionNumber);
        List<HgFileRevision> logResult = HgHistoryProvider.getHistory(revision == null ? hgFile.toFilePath() : fileToAnnotate.toFilePath(), vcsRoot, this.myProject, null, -1);
        HgAnnotation hgAnnotation = new HgAnnotation(this.myProject, hgFile, annotationResult, logResult, revisionNumber != null ? revisionNumber : new HgWorkingCopyRevisionsCommand(this.myProject).tip(vcsRoot));
        if (hgAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        return hgAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (vcsRoot == null) {
            throw new VcsException("vcs root is null for " + path);
        }
        HgFile hgFile = new HgFile(vcsRoot, path);
        List<HgAnnotationLine> annotationResult = new HgAnnotateCommand(this.myProject).execute(hgFile, (HgRevisionNumber)revision);
        List<HgFileRevision> logResult = HgHistoryProvider.getHistory(hgFile.toFilePath(), vcsRoot, this.myProject, (HgRevisionNumber)revision, -1);
        HgAnnotation hgAnnotation = new HgAnnotation(this.myProject, hgFile, annotationResult, logResult, revision);
        if (hgAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider", "annotate"));
        }
        return hgAnnotation;
    }
}

