/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitSession;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.provider.commit.HgCheckinEnvironment;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgCloseBranchExecutor
extends CommitExecutorBase {
    @NotNull
    private final HgCheckinEnvironment myCheckinEnvironment;
    @NotNull
    private static final String CLOSE_BRANCH_TITLE = "Commit And Close";

    public HgCloseBranchExecutor(@NotNull HgCheckinEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/zmlx/hg4idea/provider/commit/HgCloseBranchExecutor", "<init>"));
        }
        this.myCheckinEnvironment = environment;
    }

    public boolean areChangesRequired() {
        return false;
    }

    @Nls
    public String getActionText() {
        return CLOSE_BRANCH_TITLE;
    }

    @NotNull
    public CommitSession createCommitSession() {
        this.myCheckinEnvironment.setCloseBranch(true);
        CommitSession commitSession = CommitSession.VCS_COMMIT;
        if (commitSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/commit/HgCloseBranchExecutor", "createCommitSession"));
        }
        return commitSession;
    }

    public void setRepositories(@NotNull Collection<HgRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/provider/commit/HgCloseBranchExecutor", "setRepositories"));
        }
        this.myCheckinEnvironment.setRepos(repositories);
    }
}

