/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    public static final String NAME = "android-gradle";
    private static final String APPLY_KOTLIN_ANDROID = "apply plugin: 'kotlin-android'";

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JvmPlatform jvmPlatform = JvmPlatform.INSTANCE;
        if (jvmPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getTargetPlatform"));
        }
        return jvmPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("Android with Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getPresentableText"));
        }
        return "Android with Gradle";
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "isApplicable"));
        }
        return KotlinPluginUtil.isAndroidGradleModule(module);
    }

    @Override
    protected String getApplyPluginDirective() {
        return APPLY_KOTLIN_ANDROID;
    }

    @Override
    protected boolean addElementsToFile(@NotNull GroovyFile groovyFile, boolean isTopLevelProjectFile, @NotNull String version) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "addElementsToFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "addElementsToFile"));
        }
        if (isTopLevelProjectFile) {
            return Companion.addElementsToProjectFile(groovyFile, version);
        }
        return this.addElementsToModuleFile(groovyFile, version);
    }

    @Override
    @NotNull
    public String getRuntimeLibrary(@Nullable Sdk sdk, @NotNull String version) {
        JavaSdkVersion sdkVersion;
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getRuntimeLibrary"));
        }
        if (sdk != null && KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime(version) && (sdkVersion = JavaSdk.getInstance().getVersion(sdk)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            String string = KotlinWithGradleConfigurator.Companion.getDependencySnippet(KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE7());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getRuntimeLibrary"));
            }
            return string;
        }
        String string = super.getRuntimeLibrary(sdk, version);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/android/configure/KotlinAndroidGradleModuleConfigurator", "getRuntimeLibrary"));
        }
        return string;
    }

    KotlinAndroidGradleModuleConfigurator() {
    }
}

