/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;

public class Args {
    public static final ValueCreator FROM_STRING_CONSTRUCTOR = new ValueCreator(){

        @Override
        public Object createValue(Class<?> type2, String value2) {
            Object v = null;
            try {
                Constructor<?> init2 = type2.getDeclaredConstructor(String.class);
                v = init2.newInstance(value2);
            }
            catch (NoSuchMethodException init2) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert " + value2 + " to type " + type2.getName(), e);
            }
            return v;
        }
    };
    public static final ValueCreator ENUM_CREATOR = new ValueCreator(){

        public Object createValue(Class type2, String value2) {
            if (Enum.class.isAssignableFrom(type2)) {
                return Enum.valueOf(type2, value2);
            }
            return null;
        }
    };
    private static final List<ValueCreator> DEFAULT_VALUE_CREATORS = Arrays.asList(FROM_STRING_CONSTRUCTOR, ENUM_CREATOR);
    private static List<ValueCreator> valueCreators = new ArrayList<ValueCreator>(DEFAULT_VALUE_CREATORS);

    public static List<String> parseOrExit(Object target, String[] args) {
        try {
            return Args.parse(target, args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage(target);
            System.exit(1);
            throw e;
        }
    }

    public static List<String> parse(Object target, String[] args) {
        return Args.parse(target, args, true);
    }

    public static List<String> parse(Object target, String[] args, boolean failOnExtraFlags) {
        Class<?> clazz;
        ArrayList<String> arguments2 = new ArrayList<String>();
        arguments2.addAll(Arrays.asList(args));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments2);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field2 : currentClazz.getDeclaredFields()) {
                Args.processField(target, field2, arguments2);
            }
        }
        if (failOnExtraFlags) {
            for (String argument2 : arguments2) {
                if (!argument2.startsWith("-")) continue;
                throw new IllegalArgumentException("Invalid argument: " + argument2);
            }
        }
        return arguments2;
    }

    private static void processField(Object target, Field field2, List<String> arguments2) {
        Argument argument2 = field2.getAnnotation(Argument.class);
        if (argument2 != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument2.prefix();
                String delimiter = argument2.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name2 = Args.getName(argument2, field2);
                String alias = Args.getAlias(argument2);
                arg = arg.substring(prefix.length());
                Class<?> type2 = field2.getType();
                if (arg.equals(name2) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value2 = Args.consumeArgumentValue(type2, argument2, i);
                    if (!set) {
                        Args.setField(type2, field2, target, value2, delimiter);
                    } else {
                        Args.addArgument(type2, field2, target, value2, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument2.required()) {
                String name3 = Args.getName(argument2, field2);
                throw new IllegalArgumentException("You must set argument " + name3);
            }
        }
    }

    private static void addArgument(Class type2, Field field2, Object target, Object value2, String delimiter) {
        try {
            Object[] os = (Object[])field2.get(target);
            Object[] vs = (Object[])Args.getValue(type2, value2, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            field2.set(target, s);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static void addPropertyArgument(Class type2, PropertyDescriptor property2, Object target, Object value2, String delimiter) {
        try {
            Object[] os = (Object[])property2.getReadMethod().invoke(target, new Object[0]);
            Object[] vs = (Object[])Args.getValue(type2, value2, delimiter);
            Object[] s = (Object[])Array.newInstance(type2.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            property2.getWriteMethod().invoke(target, new Object[]{s});
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value2 + " for " + property2);
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property2, List<String> arguments2) {
        Argument argument2;
        Method writeMethod = property2.getWriteMethod();
        if (writeMethod != null && (argument2 = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments2.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument2.prefix();
                String delimiter = argument2.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name2 = Args.getName(argument2, property2);
                String alias = Args.getAlias(argument2);
                arg = arg.substring(prefix.length());
                Class<?> type2 = property2.getPropertyType();
                if (arg.equals(name2) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value2 = Args.consumeArgumentValue(type2, argument2, i);
                    if (!set) {
                        Args.setProperty(type2, property2, target, value2, delimiter);
                    } else {
                        Args.addPropertyArgument(type2, property2, target, value2, delimiter);
                    }
                    set = true;
                }
                if (!set || type2.isArray()) continue;
                break;
            }
            if (!set && argument2.required()) {
                String name3 = Args.getName(argument2, property2);
                throw new IllegalArgumentException("You must set argument " + name3);
            }
        }
    }

    public static void usage(Object target) {
        Args.usage(System.err, target);
    }

    public static void usage(PrintStream errStream, Object target) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        errStream.println("Usage: " + clazz.getName());
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field2 : currentClazz.getDeclaredFields()) {
                Args.fieldUsage(errStream, target, field2);
            }
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Args.propertyUsage(errStream, target, pd);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void fieldUsage(PrintStream errStream, Object target, Field field2) {
        Argument argument2 = field2.getAnnotation(Argument.class);
        if (argument2 != null) {
            String name2 = Args.getName(argument2, field2);
            String alias = Args.getAlias(argument2);
            String prefix = argument2.prefix();
            String delimiter = argument2.delimiter();
            String description = argument2.description();
            Args.makeAccessible(field2);
            try {
                Object defaultValue = field2.get(target);
                Class<?> type2 = field2.getType();
                Args.propertyUsage(errStream, prefix, name2, alias, type2, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field2 + " as an argument field", e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, Object target, PropertyDescriptor field2) {
        Argument argument2;
        Method writeMethod = field2.getWriteMethod();
        if (writeMethod != null && (argument2 = writeMethod.getAnnotation(Argument.class)) != null) {
            String name2 = Args.getName(argument2, field2);
            String alias = Args.getAlias(argument2);
            String prefix = argument2.prefix();
            String delimiter = argument2.delimiter();
            String description = argument2.description();
            try {
                Method readMethod = field2.getReadMethod();
                Object defaultValue = readMethod == null ? null : readMethod.invoke(target, (Object[])null);
                Class<?> type2 = field2.getPropertyType();
                Args.propertyUsage(errStream, prefix, name2, alias, type2, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field2 + " as an argument field", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not get default value for " + field2, e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, String prefix, String name2, String alias, Class<?> type2, String delimiter, String description, Object defaultValue) {
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(name2);
        if (alias != null) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(alias);
            sb.append(")");
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            sb.append(" [flag] ");
            sb.append(description);
        } else {
            String typeName;
            sb.append(" [");
            if (type2.isArray()) {
                typeName = Args.getTypeName(type2.getComponentType());
                sb.append(typeName);
                sb.append("[");
                sb.append(delimiter);
                sb.append("]");
            } else {
                typeName = Args.getTypeName(type2);
                sb.append(typeName);
            }
            sb.append("] ");
            sb.append(description);
            if (defaultValue != null) {
                sb.append(" (");
                if (type2.isArray()) {
                    ArrayList<Object> list2 = new ArrayList<Object>();
                    int len = Array.getLength(defaultValue);
                    for (int i = 0; i < len; ++i) {
                        list2.add(Array.get(defaultValue, i));
                    }
                    sb.append(list2);
                } else {
                    sb.append(defaultValue);
                }
                sb.append(")");
            }
        }
        errStream.println(sb);
    }

    private static String getTypeName(Class<?> type2) {
        String typeName = type2.getName();
        int beginIndex = typeName.lastIndexOf(".");
        typeName = typeName.substring(beginIndex + 1);
        return typeName;
    }

    static String getName(Argument argument2, PropertyDescriptor property2) {
        String name2 = argument2.value();
        if (name2.equals("")) {
            name2 = property2.getName();
        }
        return name2;
    }

    private static Object consumeArgumentValue(Class<?> type2, Argument argument2, Iterator<String> i) {
        Object value2;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            value2 = true;
        } else if (i.hasNext()) {
            value2 = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument2.value());
        }
        return value2;
    }

    static void setProperty(Class<?> type2, PropertyDescriptor property2, Object target, Object value2, String delimiter) {
        try {
            value2 = Args.getValue(type2, value2, delimiter);
            property2.getWriteMethod().invoke(target, value2);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value2 + " for " + property2);
        }
    }

    static String getAlias(Argument argument2) {
        String alias = argument2.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument2, Field field2) {
        String name2 = argument2.value();
        if (name2.equals("")) {
            name2 = field2.getName();
        }
        return name2;
    }

    static void setField(Class<?> type2, Field field2, Object target, Object value2, String delimiter) {
        Args.makeAccessible(field2);
        try {
            value2 = Args.getValue(type2, value2, delimiter);
            field2.set(target, value2);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field2, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type2.getName() + " that takes a string", e);
        }
    }

    private static Object getValue(Class<?> type2, Object value2, String delimiter) throws NoSuchMethodException {
        if (type2 != String.class && type2 != Boolean.class && type2 != Boolean.TYPE) {
            String string = (String)value2;
            if (type2.isArray()) {
                String[] strings = string.split(delimiter);
                if ((type2 = type2.getComponentType()) == String.class) {
                    value2 = strings;
                } else {
                    Object[] array = (Object[])Array.newInstance(type2, strings.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type2, strings[i]);
                    }
                    value2 = array;
                }
            } else {
                value2 = Args.createValue(type2, string);
            }
        }
        return value2;
    }

    private static Object createValue(Class<?> type2, String valueAsString) throws NoSuchMethodException {
        for (ValueCreator valueCreator : valueCreators) {
            Object createdValue = valueCreator.createValue(type2, valueAsString);
            if (createdValue == null) continue;
            return createdValue;
        }
        throw new IllegalArgumentException(String.format("cannot instanciate any %s object using %s value", type2.toString(), valueAsString));
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }

    public static ValueCreator byStaticMethodInvocation(final Class<?> compatibleType, final String methodName) {
        return new ValueCreator(){

            @Override
            public Object createValue(Class<?> type2, String value2) {
                Object v = null;
                if (compatibleType.isAssignableFrom(type2)) {
                    try {
                        Method m = type2.getMethod(methodName, String.class);
                        return m.invoke(null, value2);
                    }
                    catch (NoSuchMethodException m) {
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("could not invoke %s#%s to create an obejct from %s", type2.toString(), methodName, value2));
                    }
                }
                return v;
            }
        };
    }

    public static void registerValueCreator(ValueCreator vc) {
        valueCreators.add(vc);
    }

    public static void resetValueCreators() {
        valueCreators.clear();
        valueCreators.addAll(DEFAULT_VALUE_CREATORS);
    }

    public static interface ValueCreator {
        public Object createValue(Class<?> var1, String var2);
    }
}

