/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BridgeForBuiltinSpecial;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.GenerateJava8ParameterNamesKt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmStaticInCompanionObjectGenerator;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithOnlyTargetedAnnotations;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;
    private final Function1<DeclarationDescriptor, Boolean> IS_PURE_INTERFACE_CHECKER;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, @NotNull MemberCodegen<?> memberCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (memberCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        this.IS_PURE_INTERFACE_CHECKER = new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2, FunctionCodegen.this.state);
            }
        };
        this.owner = owner;
        this.v = v;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull KtNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor2 = this.bindingContext.get(BindingContext.FUNCTION, function2);
        if (this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor2) != null) {
            functionDescriptor2 = (SimpleFunctionDescriptor)this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor2);
        }
        if (functionDescriptor2 == null) {
            throw ExceptionLogger.logDescriptorNotFound("No descriptor for function " + function2.getName(), function2);
        }
        if (this.owner.getContextKind() != OwnerKind.DEFAULT_IMPLS || function2.hasBody()) {
            FunctionGenerationStrategy.CodegenBased strategy = functionDescriptor2.isSuspend() ? new SuspendFunctionGenerationStrategy(this.state, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor2), function2) : new FunctionGenerationStrategy.FunctionDefault(this.state, function2);
            this.generateMethod(JvmDeclarationOriginKt.OtherOrigin(function2, (DeclarationDescriptor)functionDescriptor2), functionDescriptor2, strategy);
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor2, true), functionDescriptor2, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function2);
        this.generateOverloadsWithDefaultValues(function2, functionDescriptor2, functionDescriptor2);
    }

    public void generateOverloadsWithDefaultValues(@Nullable KtNamedFunction function2, @NotNull FunctionDescriptor functionDescriptor2, @NotNull FunctionDescriptor delegateFunctionDescriptor) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateOverloadsWithDefaultValues"));
        }
        if (delegateFunctionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunctionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateOverloadsWithDefaultValues"));
        }
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(function2, functionDescriptor2, delegateFunctionDescriptor, this.owner.getContextKind(), this.v, this.memberCodegen);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            this.generateMethod(origin, CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.bindingContext), strategy);
            return;
        }
        this.generateMethod(origin, descriptor2, this.owner.intoFunction(descriptor2), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        boolean staticInCompanionObject;
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        OwnerKind contextKind = methodContext.getContextKind();
        if (DescriptorUtils.isInterface(functionDescriptor2.getContainingDeclaration()) && functionDescriptor2.getVisibility() == Visibilities.PRIVATE && !FunctionCodegen.processInterfaceMember(functionDescriptor2, contextKind, this.state)) {
            return;
        }
        JvmMethodGenericSignature jvmSignature = this.typeMapper.mapSignatureWithGeneric(functionDescriptor2, contextKind);
        Method asmMethod = jvmSignature.getAsmMethod();
        int flags = AsmUtil.getMethodAsmFlags(functionDescriptor2, contextKind, this.state);
        if (origin.getOriginKind() == JvmDeclarationOriginKind.SAM_DELEGATION) {
            flags |= 0x1000;
        }
        if (functionDescriptor2.isExternal() && this.owner instanceof MultifileClassFacadeContext) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(origin, flags, asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor2, this.typeMapper));
        if (CodegenContextUtil.isImplClassOwner(this.owner)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, CodegenUtilKt.unwrapFrontendVersion(functionDescriptor2), asmMethod);
        }
        this.generateMethodAnnotations(functionDescriptor2, asmMethod, mv);
        JvmMethodSignature signature = this.typeMapper.mapSignatureSkipGeneric(functionDescriptor2);
        this.generateParameterAnnotations(functionDescriptor2, mv, signature);
        GenerateJava8ParameterNamesKt.generateParameterNames(functionDescriptor2, mv, signature, this.state, (flags & 0x1000) != 0);
        this.generateBridges(functionDescriptor2);
        if (JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor2, this.state) && contextKind != OwnerKind.DEFAULT_IMPLS && this.state.getGenerateDefaultImplsForJvm8()) {
            this.generateDelegateForDefaultImpl(functionDescriptor2, origin.getElement());
        }
        if (staticInCompanionObject = CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor2)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new JvmStaticInCompanionObjectGenerator(functionDescriptor2, origin, this.state, parentBodyCodegen));
        }
        if (!this.state.getClassBuilderMode().generateBodies || AsmUtil.isAbstractMethod(functionDescriptor2, contextKind, this.state)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor2, FunctionCodegen.getThisTypeForFunction(functionDescriptor2, methodContext, this.typeMapper), new Label(), new Label(), contextKind, this.typeMapper, 0);
            mv.visitEnd();
            return;
        }
        if (!functionDescriptor2.isExternal()) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor2, methodContext, jvmSignature, strategy, this.memberCodegen);
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = JvmStaticInCompanionObjectGenerator.createStaticFunctionDescriptor(functionDescriptor2);
            Method accessorMethod = this.typeMapper.mapAsmMethod(this.memberCodegen.getContext().accessibleDescriptor(staticFunctionDescriptor, null));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToStaticMethodBody(false, mv, accessorMethod, owningType.getInternalName());
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private void generateDelegateForDefaultImpl(final @NotNull FunctionDescriptor functionDescriptor2, @Nullable PsiElement element2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateForDefaultImpl"));
        }
        Method defaultImplMethod = this.typeMapper.mapAsmMethod(functionDescriptor2, OwnerKind.DEFAULT_IMPLS);
        CodegenUtilKt.generateMethod(this.v, "Default Impl delegate in interface", 4105, new Method(defaultImplMethod.getName() + "$defaultImpl", defaultImplMethod.getDescriptor()), element2, JvmDeclarationOrigin.NO_ORIGIN, this.state, (Function1<? super InstructionAdapter, Unit>)new Function1<InstructionAdapter, Unit>(){

            public Unit invoke(InstructionAdapter adapter) {
                Method interfaceMethod = FunctionCodegen.this.typeMapper.mapAsmMethod(functionDescriptor2, OwnerKind.IMPLEMENTATION);
                Type type2 = FunctionCodegen.this.typeMapper.mapOwner(functionDescriptor2);
                FunctionCodegen.generateDelegateToMethodBody(-1, (MethodVisitor)adapter, interfaceMethod, type2.getInternalName(), 183, true);
                return null;
            }
        });
    }

    private void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor2, Method asmMethod, MethodVisitor mv) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodAnnotations"));
        }
        FunctionCodegen.generateMethodAnnotations(functionDescriptor2, asmMethod, mv, this.memberCodegen, this.typeMapper);
    }

    public static void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor2, Method asmMethod, MethodVisitor mv, @NotNull InnerClassConsumer consumer2, @NotNull KotlinTypeMapper typeMapper) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodAnnotations"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodAnnotations"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodAnnotations"));
        }
        AnnotationCodegen annotationCodegen = AnnotationCodegen.forMethod(mv, consumer2, typeMapper);
        if (functionDescriptor2 instanceof PropertyAccessorDescriptor) {
            AnnotationUseSiteTarget target = functionDescriptor2 instanceof PropertySetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
            annotationCodegen.genAnnotations(functionDescriptor2, asmMethod.getReturnType(), target);
        } else {
            annotationCodegen.genAnnotations(functionDescriptor2, asmMethod.getReturnType());
        }
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        FunctionCodegen.generateParameterAnnotations(functionDescriptor2, mv, jvmSignature, this.memberCodegen, this.state);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (innerClassConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassConsumer", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        FunctionCodegen.generateParameterAnnotations(functionDescriptor2, mv, jvmSignature, functionDescriptor2.getValueParameters(), innerClassConsumer, state);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (innerClassConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassConsumer", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        KotlinTypeMapper typeMapper = state.getTypeMapper();
        Iterator<ValueParameterDescriptor> iterator2 = valueParameters.iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            ReceiverParameterDescriptor receiver;
            AnnotationCodegen annotationCodegen;
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind2 = parameterSignature.getKind();
            if (kind2.isSkippedInGenericSignature()) {
                FunctionCodegen.markEnumOrInnerConstructorParameterAsSynthetic(mv, i, state.getClassBuilderMode());
                continue;
            }
            if (kind2 == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = iterator2.next();
                annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
                if (functionDescriptor2 instanceof PropertySetterDescriptor) {
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)functionDescriptor2).getCorrespondingProperty();
                    AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(propertyDescriptor);
                    annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.SETTER_PARAMETER);
                }
                if (functionDescriptor2 instanceof ConstructorDescriptor) {
                    annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType(), AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
                    continue;
                }
                annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType());
                continue;
            }
            if (kind2 != JvmMethodParameterKind.RECEIVER || (receiver = JvmCodegenUtil.getDirectMember(functionDescriptor2).getExtensionReceiverParameter()) == null) continue;
            annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
            AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(receiver.getType());
            annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.RECEIVER);
            annotationCodegen.genAnnotations(receiver, parameterSignature.getAsmType());
        }
    }

    private static void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i, ClassBuilderMode mode) {
        if (mode == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodContext context, @NotNull KotlinTypeMapper typeMapper) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor2.getDispatchReceiverParameter();
        if (functionDescriptor2 instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor2);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapType(dispatchReceiver.getType());
        }
        if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor2) || ExpressionTypingUtils.isLocalFunction(functionDescriptor2) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor2)) {
            return typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        String name2;
        int indexOfLambdaOrdinal;
        Label methodEnd;
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        KotlinTypeMapper typeMapper = parentCodegen.typeMapper;
        if (BuiltinSpecialBridgesUtil.shouldHaveTypeSafeBarrier(functionDescriptor2, FunctionCodegen.getSignatureMapper(typeMapper))) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(new InstructionAdapter(mv), functionDescriptor2, signature.getReturnType(), null);
        }
        int functionFakeIndex = -1;
        int lambdaFakeIndex = -1;
        if (context.getParentContext() instanceof MultifileClassFacadeContext) {
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, signature.getAsmMethod(), (MultifileClassFacadeContext)context.getParentContext());
            methodEnd = new Label();
        } else if (OwnerKind.DEFAULT_IMPLS == context.getContextKind() && JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor2, parentCodegen.state)) {
            int flags = AsmUtil.getMethodAsmFlags(functionDescriptor2, OwnerKind.DEFAULT_IMPLS, context.getState());
            assert ((flags & 0x400) == 0) : "Interface method with body should be non-abstract" + functionDescriptor2;
            Type type2 = typeMapper.mapOwner(functionDescriptor2);
            Method asmMethod = typeMapper.mapAsmMethod(functionDescriptor2, OwnerKind.DEFAULT_IMPLS);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, new Method(asmMethod.getName() + "$defaultImpl", asmMethod.getDescriptor()), type2.getInternalName());
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, functionDescriptor2, signature, AsmUtil.isStaticMethod(context.getContextKind(), functionDescriptor2));
            if (context.isInlineMethodContext()) {
                functionFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            if (context instanceof InlineLambdaContext) {
                lambdaFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!KotlinTypeMapper.isAccessor(functionDescriptor2)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor2, frameMap);
            }
            parentCodegen.beforeMethodBody(mv);
            methodEnd = new Label();
            context.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature, context, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor2, context, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor2, thisType, methodBegin, methodEnd, context.getContextKind(), typeMapper, (functionFakeIndex >= 0 ? 1 : 0) + (lambdaFakeIndex >= 0 ? 1 : 0));
        if (context.isInlineMethodContext() && functionFakeIndex != -1) {
            mv.visitLocalVariable("$i$f$" + typeMapper.mapAsmMethod(functionDescriptor2).getName(), Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, functionFakeIndex);
        }
        if (context instanceof InlineLambdaContext && thisType != null && lambdaFakeIndex != -1 && (indexOfLambdaOrdinal = (name2 = thisType.getClassName()).lastIndexOf("$")) > 0) {
            ValueParameterDescriptor inlineArgumentDescriptor;
            int lambdaOrdinal2 = Integer.parseInt(name2.substring(indexOfLambdaOrdinal + 1));
            Object functionArgument = parentCodegen.element;
            String functionName2 = "unknown";
            if (functionArgument instanceof KtFunction && (inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)functionArgument, parentCodegen.bindingContext)) != null) {
                functionName2 = inlineArgumentDescriptor.getContainingDeclaration().getName().asString();
            }
            mv.visitLocalVariable("$i$a$" + lambdaOrdinal2 + "$" + functionName2, Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, lambdaFakeIndex);
        }
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor2, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind, @NotNull KotlinTypeMapper typeMapper, int shiftForDestructuringVariables) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, functionDescriptor2.getValueParameters(), AsmUtil.isStaticMethod(ownerKind, functionDescriptor2), typeMapper, shiftForDestructuringVariables);
    }

    public static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, boolean isStatic, KotlinTypeMapper typeMapper) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, valueParameters, isStatic, typeMapper, 0);
    }

    private static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, boolean isStatic, KotlinTypeMapper typeMapper, int shiftForDestructuringVariables) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariablesForParameters"));
        }
        Iterator<ValueParameterDescriptor> valueParameterIterator = valueParameters.iterator();
        List<JvmMethodParameterSignature> params2 = jvmMethodSignature.getValueParameters();
        int shift = 0;
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params2.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params2.get(i);
            JvmMethodParameterKind kind2 = param.getKind();
            if (kind2 == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameterIterator.next();
                List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
                parameterName = destructuringVariables == null ? FunctionCodegen.computeParameterName(i, parameter) : "$" + FunctionCodegen.joinParameterNames(destructuringVariables);
            } else {
                String lowercaseKind = kind2.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind2) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
        shift += shiftForDestructuringVariables;
        for (ValueParameterDescriptor parameter : valueParameters) {
            List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
            if (destructuringVariables == null) continue;
            for (VariableDescriptor entry : CodegenUtilKt.filterOutDescriptorsWithSpecialNames(destructuringVariables)) {
                Type type3 = typeMapper.mapType(entry.getType());
                mv.visitLocalVariable(entry.getName().asString(), type3.getDescriptor(), null, methodBegin, methodEnd, shift);
                shift += type3.getSize();
            }
        }
    }

    private static String computeParameterName(int i, ValueParameterDescriptor parameter) {
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
        if (element2 instanceof KtParameter && UnderscoreUtilKt.isSingleUnderscore((KtParameter)element2)) {
            return "$noName_" + i;
        }
        return parameter.getName().asString();
    }

    private static String joinParameterNames(@NotNull List<VariableDescriptor> variables) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/kotlin/codegen/FunctionCodegen", "joinParameterNames"));
        }
        return StringsKt.join(CollectionsKt.map(variables, (Function1)new Function1<VariableDescriptor, String>(){

            public String invoke(VariableDescriptor descriptor2) {
                if (descriptor2.getName().isSpecial()) {
                    return "$_$";
                }
                return descriptor2.getName().asString();
            }
        }), "_");
    }

    private static void generateFacadeDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull MultifileClassFacadeContext context) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateFacadeDelegateMethodBody"));
        }
        FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, asmMethod, context.getFilePartType().getInternalName());
    }

    private static void generateDelegateToMethodBody(int firstParamIndex, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo, int opcode, boolean isInterface) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (classToDelegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToDelegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label2 = new Label();
        iv.visitLabel(label2);
        iv.visitLineNumber(1, label2);
        int paramIndex = firstParamIndex;
        if (paramIndex == -1) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
            paramIndex = 1;
        }
        for (Type argType : argTypes) {
            iv.load(paramIndex, argType);
            paramIndex += argType.getSize();
        }
        iv.visitMethodInsn(opcode, classToDelegateTo, asmMethod.getName(), asmMethod.getDescriptor(), isInterface);
        iv.areturn(asmMethod.getReturnType());
    }

    private static void generateDelegateToStaticMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToStaticMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToStaticMethodBody"));
        }
        if (classToDelegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToDelegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToStaticMethodBody"));
        }
        FunctionCodegen.generateDelegateToMethodBody(isStatic ? 0 : 1, mv, asmMethod, classToDelegateTo, 184, false);
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind2) {
        return kind2 == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind2 == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind2 == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description) {
        FunctionCodegen.endVisit(mv, description, (PsiElement)null);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable KtPureElement method) {
        FunctionCodegen.endVisit(mv, description, (PsiElement)(method == null ? null : method.getPsiOrParent()));
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @NotNull KtElement method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/FunctionCodegen", "endVisit"));
        }
        FunctionCodegen.endVisit(mv, description, (PsiElement)method);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode2 = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated\n" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode2 != null ? "\nbytecode:\n" + bytecode2 : ""), t, method);
        }
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode2 = null;
        if (mv instanceof TransformationMethodVisitor) {
            mv = ((TransformationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode2 = sw.toString();
        }
        return bytecode2;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor2) {
        boolean isSpecial;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridges"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        if (JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2.getContainingDeclaration(), this.state)) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor2)) {
            return;
        }
        boolean bl = isSpecial = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) != null;
        if (!isSpecial) {
            Set<Bridge<Method>> bridgesToGenerate = ImplKt.generateBridgesForFunctionDescriptor(descriptor2, FunctionCodegen.getSignatureMapper(this.typeMapper), this.IS_PURE_INTERFACE_CHECKER);
            if (!bridgesToGenerate.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                boolean isSpecialBridge = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2) != null;
                for (Bridge<Method> bridge : bridgesToGenerate) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), isSpecialBridge, false);
                }
            }
        } else {
            Set<BridgeForBuiltinSpecial<Method>> specials = BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, FunctionCodegen.getSignatureMapper(this.typeMapper), this.IS_PURE_INTERFACE_CHECKER);
            if (!specials.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                for (BridgeForBuiltinSpecial<Method> bridge : specials) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), bridge.isSpecial(), bridge.isDelegateToSuper());
                }
            }
            if (!descriptor2.getKind().isReal() && AsmUtil.isAbstractMethod(descriptor2, OwnerKind.IMPLEMENTATION, this.state)) {
                FunctionDescriptor overridden = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2);
                assert (overridden != null);
                if (!FunctionCodegen.isThereOverriddenInKotlinClass(descriptor2)) {
                    Method method = this.typeMapper.mapAsmMethod(descriptor2);
                    int flags = 0x400 | AsmUtil.getVisibilityAccessFlag(descriptor2);
                    this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(overridden), flags, method.getName(), method.getDescriptor(), null, null);
                }
            }
        }
    }

    public static boolean isThereOverriddenInKotlinClass(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isThereOverriddenInKotlinClass"));
        }
        return CollectionsKt.any(DescriptorUtils.getAllOverriddenDescriptors(descriptor2), (Function1)new Function1<CallableMemberDescriptor, Boolean>(){

            public Boolean invoke(CallableMemberDescriptor descriptor2) {
                return !(descriptor2.getContainingDeclaration() instanceof JavaClassDescriptor) && DescriptorUtils.isClass(descriptor2.getContainingDeclaration());
            }
        });
    }

    @NotNull
    private static Function1<FunctionDescriptor, Method> getSignatureMapper(final @NotNull KotlinTypeMapper typeMapper) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getSignatureMapper"));
        }
        Function1<FunctionDescriptor, Method> function1 = new Function1<FunctionDescriptor, Method>(){

            public Method invoke(FunctionDescriptor descriptor2) {
                return typeMapper.mapAsmMethod(descriptor2);
            }
        };
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getSignatureMapper"));
        }
        return function1;
    }

    public static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isMethodOfAny"));
        }
        String name2 = descriptor2.getName().asString();
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.isEmpty()) {
            return name2.equals("hashCode") || name2.equals("toString");
        }
        if (parameters2.size() == 1 && name2.equals("equals")) {
            return KotlinBuiltIns.isNullableAny(parameters2.get(0).getType());
        }
        return false;
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function2, final @NotNull KotlinTypeMapper mapper) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        AnnotationDescriptor annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation2 == null) {
            annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.jvm.Throws"));
        }
        if (annotation2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<ConstantValue<?>> values = annotation2.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ConstantValue<?> value2 = values.iterator().next();
        if (!(value2 instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value2;
        List strings = ContainerUtil.mapNotNull((Collection)((Collection)arrayValue.getValue()), (Function)new Function<ConstantValue<?>, String>(){

            public String fun(ConstantValue<?> constant) {
                if (constant instanceof KClassValue) {
                    KClassValue classValue = (KClassValue)constant;
                    ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                    return mapper.mapClass(classDescriptor).getInternalName();
                }
                return null;
            }
        });
        String[] stringArray = ArrayUtil.toStringArray((Collection)strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        return stringArray;
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor2, @NotNull OwnerKind kind2, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (DescriptorUtils.isInterface(contextClass) && !FunctionCodegen.processInterface(contextClass, kind2, this.state)) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor2)) {
            return;
        }
        int visibilityFlag = Visibilities.isPrivate(functionDescriptor2.getVisibility()) || AnnotationUtilKt.isInlineOnlyOrReifiable(functionDescriptor2) ? 0 : 1;
        int flags = visibilityFlag | AsmUtil.getDeprecatedAccessFlag(functionDescriptor2) | 0x1000;
        if (!(functionDescriptor2 instanceof ConstructorDescriptor)) {
            flags |= 0x48;
        }
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor2, kind2);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Synthetic(function2, functionDescriptor2), flags, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor2, this.typeMapper));
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.typeMapper).genAnnotations(functionDescriptor2, defaultMethod.getReturnType());
        if (!this.state.getClassBuilderMode().generateBodies) {
            if (this.owner instanceof MultifileClassFacadeContext) {
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor2));
            } else {
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor2));
            }
            return;
        }
        if (this.owner instanceof MultifileClassFacadeContext) {
            mv.visitCode();
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, defaultMethod, (MultifileClassFacadeContext)this.owner);
            FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor2));
        } else {
            mv.visitCode();
            FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor2, mv, loadStrategy, function2, this.memberCodegen, defaultMethod);
            FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor2));
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull FunctionDescriptor functionDescriptor2, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2, @NotNull MemberCodegen<?> parentCodegen, @NotNull Method defaultMethod) {
        int parameterIndex2;
        Type type2;
        ValueParameterDescriptor parameterDescriptor;
        int index2;
        int capturedArgumentsCount;
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (defaultMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        GenerationState state = parentCodegen.state;
        JvmMethodGenericSignature signature = state.getTypeMapper().mapSignatureWithGeneric(functionDescriptor2, methodContext.getContextKind());
        boolean isStatic = AsmUtil.isStaticMethod(methodContext.getContextKind(), functionDescriptor2);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state, functionDescriptor2, signature, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGeneratorForDefaultImplBody(functionDescriptor2, function2);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.genDefaultSuperCallCheckIfNeeded(iv, functionDescriptor2, defaultMethod);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        int maskIndex = 0;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor2.getValueParameters();
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            if (index2 % 32 == 0) {
                maskIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            parameterDescriptor = valueParameters.get(index2);
            type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            parameterIndex2 = frameMap.getIndex(parameterDescriptor);
            if (!parameterDescriptor.declaresDefaultValue()) continue;
            iv.load(maskIndex, Type.INT_TYPE);
            iv.iconst(1 << index2 % 32);
            iv.and(Type.INT_TYPE);
            Label loadArg = new Label();
            iv.ifeq(loadArg);
            StackValue.local(parameterIndex2, type2).store(loadStrategy.genValue(parameterDescriptor, codegen), iv);
            iv.mark(loadArg);
        }
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature, generator);
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            parameterDescriptor = valueParameters.get(index2);
            type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            parameterIndex2 = frameMap.getIndex(parameterDescriptor);
            generator.putValueIfNeeded(type2, StackValue.local(parameterIndex2, type2));
        }
        CallableMethod method = state.getTypeMapper().mapToCallableMethod(functionDescriptor2, false);
        generator.genCall(method, null, false, codegen);
        iv.areturn(signature.getReturnType());
    }

    private static void genDefaultSuperCallCheckIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Method defaultMethod) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDefaultSuperCallCheckIfNeeded"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDefaultSuperCallCheckIfNeeded"));
        }
        if (defaultMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDefaultSuperCallCheckIfNeeded"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)container2).getModality() == Modality.FINAL) {
            return;
        }
        Label end = new Label();
        int handleIndex = (Type.getArgumentsAndReturnSizes((String)defaultMethod.getDescriptor()) >> 2) - 2;
        iv.load(handleIndex, AsmTypes.OBJECT_TYPE);
        iv.ifnull(end);
        AsmUtil.genThrow(iv, "java/lang/UnsupportedOperationException", "Super calls with default arguments not supported in this target, function: " + descriptor2.getName().asString());
        iv.visitLabel(end);
    }

    @NotNull
    public static FrameMap createFrameMap(@NotNull GenerationState state, @NotNull FunctionDescriptor function2, @NotNull JvmMethodSignature signature, boolean isStatic) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER) {
                ReceiverParameterDescriptor receiverParameter = function2.getExtensionReceiverParameter();
                if (receiverParameter != null) {
                    frameMap.enter(receiverParameter, state.getTypeMapper().mapType(receiverParameter));
                    continue;
                }
                frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function2.getValueParameters()) {
            frameMap.enter(valueParameterDescriptor, state.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMap frameMap2 = frameMap;
        if (frameMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        return frameMap2;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(ownerType, StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(type2, StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor2) {
        boolean needed = false;
        if (functionDescriptor2 != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor2.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor2, @NotNull Method bridge, @NotNull Method delegateTo, boolean isSpecialBridge, boolean isStubDeclarationWithDelegationToSuper) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        boolean isSpecialOrDelegationToSuper = isSpecialBridge || isStubDeclarationWithDelegationToSuper;
        int flags = 0x41 | (!isSpecialOrDelegationToSuper ? 4096 : 0) | (isSpecialBridge ? 16 : 0);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Bridge(descriptor2, origin), flags, bridge.getName(), bridge.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(this.owner.getThisDescriptor(), iv);
        if (delegateTo.getArgumentTypes().length > 0 && isSpecialBridge) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(iv, descriptor2, bridge.getReturnType(), delegateTo.getArgumentTypes());
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        if (isStubDeclarationWithDelegationToSuper) {
            ClassDescriptor parentClass2 = DescriptorUtils.getSuperClassDescriptor((ClassDescriptor)descriptor2.getContainingDeclaration());
            assert (parentClass2 != null);
            String parentInternalName = this.typeMapper.mapClass(parentClass2).getInternalName();
            iv.invokespecial(parentInternalName, delegateTo.getName(), delegateTo.getDescriptor(), false);
        } else if (JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(descriptor2, this.state)) {
            iv.invokeinterface(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        } else {
            iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor(), false);
        }
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    private static void generateTypeCheckBarrierIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Type returnType2, @Nullable Type[] delegateParameterTypes) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateTypeCheckBarrierIfNeeded"));
        }
        BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription typeSafeBarrierDescription = BuiltinMethodsWithSpecialGenericSignature.getDefaultValueForOverriddenBuiltinFunction(descriptor2);
        if (typeSafeBarrierDescription == null) {
            return;
        }
        FunctionDescriptor overriddenBuiltin = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2);
        assert (overriddenBuiltin != null) : "Overridden built-in method should not be null for " + descriptor2;
        Label defaultBranch = new Label();
        for (int i = 0; i < descriptor2.getValueParameters().size(); ++i) {
            if (!typeSafeBarrierDescription.checkParameter(i)) continue;
            boolean isCheckForAny = delegateParameterTypes == null || AsmTypes.OBJECT_TYPE.equals((Object)delegateParameterTypes[i]);
            KotlinType kotlinType = descriptor2.getValueParameters().get(i).getType();
            if (isCheckForAny && TypeUtils.isNullableType(kotlinType)) continue;
            iv.load(1 + i, AsmTypes.OBJECT_TYPE);
            if (isCheckForAny) {
                assert (!TypeUtils.isNullableType(kotlinType)) : "Only bridges for not-nullable types are necessary";
                iv.ifnull(defaultBranch);
                continue;
            }
            CodegenUtilKt.generateIsCheck(iv, kotlinType, AsmUtil.boxType(delegateParameterTypes[i]));
            iv.ifeq(defaultBranch);
        }
        Label afterDefaultBranch = new Label();
        iv.goTo(afterDefaultBranch);
        iv.visitLabel(defaultBranch);
        if (typeSafeBarrierDescription.equals((Object)BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription.MAP_GET_OR_DEFAULT)) {
            iv.load(2, returnType2);
        } else {
            StackValue.constant(typeSafeBarrierDescription.getDefaultValue(), returnType2).put(returnType2, iv);
        }
        iv.areturn(returnType2);
        iv.visitLabel(afterDefaultBranch);
    }

    public void genSamDelegate(@NotNull FunctionDescriptor functionDescriptor2, FunctionDescriptor overriddenDescriptor2, StackValue field2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genSamDelegate"));
        }
        FunctionDescriptor delegatedTo = overriddenDescriptor2.getOriginal();
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.SamDelegation(functionDescriptor2);
        this.genDelegate(functionDescriptor2, delegatedTo, declarationOrigin, (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field2);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor2, FunctionDescriptor overriddenDescriptor2, StackValue field2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.genDelegate(functionDescriptor2, overriddenDescriptor2.getOriginal(), (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field2);
    }

    public void genDelegate(@NotNull FunctionDescriptor delegateFunction, FunctionDescriptor delegatedTo, ClassDescriptor toClass, StackValue field2) {
        if (delegateFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunction", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction);
        this.genDelegate(delegateFunction, delegatedTo, declarationOrigin, toClass, field2);
    }

    private void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, @NotNull JvmDeclarationOrigin declarationOrigin, final ClassDescriptor toClass, final StackValue field2) {
        if (delegateFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunction", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        if (declarationOrigin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationOrigin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.generateMethod(declarationOrigin, delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen$7", "generateBody"));
                }
                if (frameMap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/FunctionCodegen$7", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen$7", "generateBody"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen$7", "generateBody"));
                }
                if (parentCodegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen$7", "generateBody"));
                }
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapToCallableMethod(delegatedTo, false).getAsmMethod();
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapAsmMethod(delegateFunction);
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field2.put(field2.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.INTERFACE) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor(), false);
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), RuntimeAssertionInfo.create(delegateFunction.getReturnType(), delegatedTo.getReturnType(), new RuntimeAssertionInfo.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }
        });
    }

    public static boolean processInterfaceMember(@NotNull CallableMemberDescriptor function2, @NotNull OwnerKind kind2, @NotNull GenerationState state) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterfaceMember"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterfaceMember"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterfaceMember"));
        }
        return FunctionCodegen.processInterface(function2.getContainingDeclaration(), kind2, state);
    }

    public static boolean processInterface(@NotNull DeclarationDescriptor contextClass, @NotNull OwnerKind kind2, @NotNull GenerationState state) {
        if (contextClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextClass", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterface"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterface"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "processInterface"));
        }
        assert (DescriptorUtils.isInterface(contextClass)) : "'processInterface' method should be called only for interfaces, but: " + contextClass;
        return JvmCodegenUtil.isJvm8InterfaceWithDefaults(contextClass, state) ? kind2 != OwnerKind.DEFAULT_IMPLS : kind2 == OwnerKind.DEFAULT_IMPLS;
    }
}

