/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.PropertyReferenceInfo;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class LambdaInfo
implements LabelOwner {
    public final KtExpression expression;
    private final KotlinTypeMapper typeMapper;
    public final Set<String> labels;
    private final CalculatedClosure closure;
    public final boolean isCrossInline;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;
    private SMAPAndMethodNode node;
    private List<CapturedParamDesc> capturedVars;
    private final boolean isBoundCallableReference;
    private final PropertyReferenceInfo propertyReferenceInfo;

    public LambdaInfo(@NotNull KtExpression expression2, @NotNull KotlinTypeMapper typeMapper, boolean isCrossInline, boolean isBoundCallableReference) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "<init>"));
        }
        this.isCrossInline = isCrossInline;
        this.expression = expression2 instanceof KtLambdaExpression ? ((KtLambdaExpression)expression2).getFunctionLiteral() : expression2;
        this.typeMapper = typeMapper;
        this.isBoundCallableReference = isBoundCallableReference;
        BindingContext bindingContext2 = typeMapper.getBindingContext();
        FunctionDescriptor function2 = bindingContext2.get(BindingContext.FUNCTION, this.expression);
        if (function2 == null && expression2 instanceof KtCallableReferenceExpression) {
            VariableDescriptor variableDescriptor = bindingContext2.get(BindingContext.VARIABLE, this.expression);
            assert (variableDescriptor instanceof VariableDescriptorWithAccessors) : "Reference expression not resolved to variable descriptor with accessors: " + expression2.getText();
            this.classDescriptor = CodegenBinding.anonymousClassForCallable(bindingContext2, variableDescriptor);
            this.closureClassType = typeMapper.mapClass(this.classDescriptor);
            SimpleFunctionDescriptor getFunction = PropertyReferenceCodegen.findGetFunction(variableDescriptor);
            this.functionDescriptor = PropertyReferenceCodegen.createFakeOpenDescriptor(getFunction, this.classDescriptor);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(((KtCallableReferenceExpression)expression2).getCallableReference(), bindingContext2);
            this.propertyReferenceInfo = new PropertyReferenceInfo((VariableDescriptor)resolvedCall2.getResultingDescriptor(), getFunction);
        } else {
            this.propertyReferenceInfo = null;
            this.functionDescriptor = function2;
            assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + expression2.getText();
            this.classDescriptor = CodegenBinding.anonymousClassForCallable(bindingContext2, this.functionDescriptor);
            this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext2, this.functionDescriptor);
        }
        this.closure = bindingContext2.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure for lambda should be not null " + expression2.getText();
        this.labels = InlineCodegen.getDeclarationLabels((PsiElement)expression2, this.functionDescriptor);
    }

    @NotNull
    public SMAPAndMethodNode getNode() {
        SMAPAndMethodNode sMAPAndMethodNode = this.node;
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getNode"));
        }
        return sMAPAndMethodNode;
    }

    public void setNode(@NotNull SMAPAndMethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "setNode"));
        }
        this.node = node;
    }

    @NotNull
    public FunctionDescriptor getFunctionDescriptor() {
        FunctionDescriptor functionDescriptor2 = this.functionDescriptor;
        if (functionDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getFunctionDescriptor"));
        }
        return functionDescriptor2;
    }

    @NotNull
    public KtExpression getFunctionWithBodyOrCallableReference() {
        KtExpression ktExpression = this.expression;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getFunctionWithBodyOrCallableReference"));
        }
        return ktExpression;
    }

    @NotNull
    public ClassDescriptor getClassDescriptor() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public Type getLambdaClassType() {
        Type type2 = this.closureClassType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getLambdaClassType"));
        }
        return type2;
    }

    @NotNull
    public List<CapturedParamDesc> getCapturedVars() {
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor22;
            Type type2;
            this.capturedVars = new ArrayList<CapturedParamDesc>();
            if (this.closure.getCaptureThis() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureThis());
                descriptor22 = new EnclosedValueDescriptor("this$0", null, StackValue.field(type2, this.closureClassType, "this$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            if (this.closure.getCaptureReceiverType() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureReceiverType());
                descriptor22 = new EnclosedValueDescriptor("receiver$0", null, StackValue.field(type2, this.closureClassType, "receiver$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            for (EnclosedValueDescriptor descriptor22 : this.closure.getCaptureVariables().values()) {
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
        }
        List<CapturedParamDesc> list2 = this.capturedVars;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedVars"));
        }
        return list2;
    }

    @NotNull
    private CapturedParamDesc getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        CapturedParamDesc capturedParamDesc = new CapturedParamDesc(this.closureClassType, descriptor2.getFieldName(), descriptor2.getType());
        if (capturedParamDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getCapturedParamInfo"));
        }
        return capturedParamDesc;
    }

    @NotNull
    public List<Type> getInvokeParamsWithoutCaptured() {
        List<Type> list2 = Arrays.asList(this.typeMapper.mapAsmMethod(this.functionDescriptor).getArgumentTypes());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "getInvokeParamsWithoutCaptured"));
        }
        return list2;
    }

    @NotNull
    public Parameters addAllParameters(@NotNull FieldRemapper remapper) {
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        Method asmMethod = this.typeMapper.mapAsmMethod(this.getFunctionDescriptor());
        ParametersBuilder builder = ParametersBuilder.initializeBuilderFrom(AsmTypes.OBJECT_TYPE, asmMethod.getDescriptor(), this);
        for (CapturedParamDesc info : this.getCapturedVars()) {
            CapturedParamInfo field2 = remapper.findField(new FieldInsnNode(0, info.getContainingLambdaName(), info.getFieldName(), ""));
            assert (field2 != null) : "Captured field not found: " + info.getContainingLambdaName() + "." + info.getFieldName();
            builder.addCapturedParam(field2, info.getFieldName());
        }
        Parameters parameters2 = builder.buildParameters();
        if (parameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "addAllParameters"));
        }
        return parameters2;
    }

    @Override
    public boolean isMyLabel(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/LambdaInfo", "isMyLabel"));
        }
        return this.labels.contains(name2);
    }

    public boolean isBoundCallableReference() {
        return this.isBoundCallableReference;
    }

    public boolean isPropertyReference() {
        return this.propertyReferenceInfo != null;
    }

    public PropertyReferenceInfo getPropertyReferenceInfo() {
        return this.propertyReferenceInfo;
    }
}

