/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "removeDeadCodeByFrames", "Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "frames", "", "", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "transform", "", "internalClassName", "", "transformWithResult", "Result", "backend"})
public final class DeadCodeEliminationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        this.transformWithResult(internalClassName, methodNode);
    }

    @NotNull
    public final Result transformWithResult(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Frame<V>[] frames2 = MethodTransformer.analyze(internalClassName, methodNode, new OptimizationBasicInterpreter());
        Intrinsics.checkExpressionValueIsNotNull(frames2, (String)"frames");
        return this.removeDeadCodeByFrames(methodNode, frames2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result removeDeadCodeByFrames(@NotNull MethodNode methodNode, @NotNull Object[] frames2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull((Object)frames2, (String)"frames");
        HashSet<Object> removedNodes = new HashSet<Object>();
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode[] insnsArray = insnList.toArray();
        Iterable $receiver$iv = ArraysKt.zip((Object[])insnsArray, (Object[])frames2);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            if (!(it.getSecond() == null && UtilKt.isMeaningful((AbstractInsnNode)it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            insnList.remove((AbstractInsnNode)it.getFirst());
            removedNodes.add(it.getFirst());
        }
        UtilKt.removeEmptyCatchBlocks(methodNode);
        return new Result((Set<? extends AbstractInsnNode>)removedNodes);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "", "removedNodes", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "(Ljava/util/Set;)V", "getRemovedNodes", "()Ljava/util/Set;", "hasRemovedAnything", "", "isAlive", "node", "isRemoved", "backend"})
    public static final class Result {
        @NotNull
        private final Set<AbstractInsnNode> removedNodes;

        public final boolean hasRemovedAnything() {
            Collection collection = this.removedNodes;
            return !collection.isEmpty();
        }

        public final boolean isRemoved(@NotNull AbstractInsnNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.removedNodes.contains(node);
        }

        public final boolean isAlive(@NotNull AbstractInsnNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return !this.isRemoved(node);
        }

        @NotNull
        public final Set<AbstractInsnNode> getRemovedNodes() {
            return this.removedNodes;
        }

        public Result(@NotNull Set<? extends AbstractInsnNode> removedNodes) {
            Intrinsics.checkParameterIsNotNull(removedNodes, (String)"removedNodes");
            this.removedNodes = removedNodes;
        }
    }
}

