/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class LocalVariableDescriptor
extends VariableDescriptorWithInitializerImpl
implements VariableDescriptorWithAccessors {
    private final boolean isDelegated;
    private VariableAccessorDescriptor getter;
    private VariableAccessorDescriptor setter;

    public LocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name2, @Nullable KotlinType type2, boolean mutable, boolean isDelegated, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "<init>"));
        }
        super(containingDeclaration, annotations2, name2, type2, mutable, source);
        this.isDelegated = isDelegated;
    }

    @Override
    public void setOutType(KotlinType outType) {
        super.setOutType(outType);
        if (this.isDelegated) {
            this.getter = new LocalVariableAccessorDescriptor.Getter(this);
            if (this.isVar()) {
                this.setter = new LocalVariableAccessorDescriptor.Setter(this);
            }
        }
    }

    @Override
    @NotNull
    public LocalVariableDescriptor substitute(@NotNull TypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "substitute"));
        }
        if (substitutor3.isEmpty()) {
            LocalVariableDescriptor localVariableDescriptor = this;
            if (localVariableDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "substitute"));
            }
            return localVariableDescriptor;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitVariableDescriptor(this, data);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.LOCAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @Nullable
    public VariableAccessorDescriptor getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public VariableAccessorDescriptor getSetter() {
        return this.setter;
    }

    @Override
    public boolean isDelegated() {
        return this.isDelegated;
    }
}

