/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeInsight.KotlinTypeDeclarationProvider;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007J/\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/KotlinTypeDeclarationProvider;", "Lcom/intellij/codeInsight/navigation/actions/TypeDeclarationProvider;", "()V", "getSymbolTypeDeclarations", "", "Lcom/intellij/psi/PsiElement;", "symbol", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "getTypeDeclarationFromCallable", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "typeFromDescriptor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/jvm/functions/Function1;)[Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinTypeDeclarationProvider
implements TypeDeclarationProvider {
    @Nullable
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        PsiElement declaration2;
        Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
        if (!(symbol.getContainingFile() instanceof KtFile)) {
            return new PsiElement[0];
        }
        if (symbol instanceof PsiWhiteSpace) {
            PsiElement lBraceElement;
            int n = ((PsiWhiteSpace)symbol).getTextOffset() - 1;
            int n2 = 0;
            PsiFile psiFile = ((PsiWhiteSpace)symbol).getContainingFile();
            int n3 = Math.max(n, n2);
            PsiElement psiElement2 = lBraceElement = psiFile.findElementAt(n3);
            if (Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)"{")) {
                KtFunctionLiteral functionLiteral;
                PsiElement psiElement3 = lBraceElement.getParent();
                if (!(psiElement3 instanceof KtFunctionLiteral)) {
                    psiElement3 = null;
                }
                if ((functionLiteral = (KtFunctionLiteral)psiElement3) != null) {
                    return this.getTypeDeclarationFromCallable(functionLiteral, (Function1<? super CallableDescriptor, ? extends KotlinType>)((Function1)getSymbolTypeDeclarations.1.INSTANCE));
                }
            }
        }
        if (symbol instanceof KtFunctionLiteral) {
            return this.getTypeDeclarationFromCallable((KtDeclaration)symbol, (Function1<? super CallableDescriptor, ? extends KotlinType>)((Function1)getSymbolTypeDeclarations.2.INSTANCE));
        }
        if (symbol instanceof KtTypeReference && (declaration2 = ((KtTypeReference)symbol).getParent()) instanceof KtCallableDeclaration && Intrinsics.areEqual((Object)((KtCallableDeclaration)declaration2).getReceiverTypeReference(), (Object)symbol)) {
            return this.getTypeDeclarationFromCallable((KtDeclaration)declaration2, (Function1<? super CallableDescriptor, ? extends KotlinType>)((Function1)getSymbolTypeDeclarations.3.INSTANCE));
        }
        if (!(symbol instanceof KtDeclaration)) {
            return new PsiElement[0];
        }
        return this.getTypeDeclarationFromCallable((KtDeclaration)symbol, (Function1<? super CallableDescriptor, ? extends KotlinType>)((Function1)getSymbolTypeDeclarations.4.INSTANCE));
    }

    private final PsiElement[] getTypeDeclarationFromCallable(@NotNull KtDeclaration $receiver, Function1<? super CallableDescriptor, ? extends KotlinType> typeFromDescriptor) {
        Collection $receiver$iv;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default($receiver, null, 1, null);
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            return new PsiElement[0];
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        KotlinType kotlinType = (KotlinType)typeFromDescriptor.invoke((Object)callableDescriptor2);
        if (kotlinType == null) {
            return new PsiElement[0];
        }
        KotlinType type2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new PsiElement[0];
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ClassifierDescriptor classifierDescriptor3 = classifierDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor3, (String)"classifierDescriptor");
        Collection collection = $receiver$iv = DescriptorToSourceUtilsIde.getAllDeclarations$default(DescriptorToSourceUtilsIde.INSTANCE, project, classifierDescriptor3, null, 4, null);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[thisCollection$iv.size()]);
        if (psiElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiElementArray;
    }
}

