/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

public abstract class KotlinComponentUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinComponentUnwrapper(String key) {
        super(key);
    }

    @Nullable
    protected abstract KtExpression getExpressionToUnwrap(@NotNull KtElement var1);

    @NotNull
    protected KtElement getEnclosingElement(@NotNull KtElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinComponentUnwrapper", "getEnclosingElement"));
        }
        KtElement ktElement = element2;
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinComponentUnwrapper", "getEnclosingElement"));
        }
        return ktElement;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof KtElement)) {
            return false;
        }
        KtExpression expressionToUnwrap = this.getExpressionToUnwrap((KtElement)e);
        return expressionToUnwrap != null && this.canExtractExpression(expressionToUnwrap, (KtElement)this.getEnclosingElement((KtElement)e).getParent());
    }

    protected void doUnwrap(PsiElement element2, KotlinUnwrapRemoveBase.Context context) throws IncorrectOperationException {
        KtElement targetElement = (KtElement)element2;
        KtExpression expressionToUnwrap = this.getExpressionToUnwrap(targetElement);
        assert (expressionToUnwrap != null);
        KtElement enclosingElement = this.getEnclosingElement(targetElement);
        context.extractFromExpression(expressionToUnwrap, enclosingElement);
        context.delete((PsiElement)enclosingElement);
    }
}

