/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

public class KotlinDeclarationMover
extends AbstractKotlinUpDownMover {
    private boolean moveEnumConstant = false;
    private static final Class[] DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtAnonymousInitializer.class, KtFunction.class, KtPropertyAccessor.class, KtFile.class};
    private static final Class[] CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtFile.class};

    private static int findNearestNonWhitespace(@NotNull CharSequence sequence2, int index2) {
        if (sequence2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "findNearestNonWhitespace"));
        }
        char ch = sequence2.charAt(--index2);
        while (Character.isWhitespace(ch)) {
            ch = sequence2.charAt(--index2);
        }
        return index2;
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "afterMove"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "afterMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "afterMove"));
        }
        super.afterMove(editor, file2, info, down);
        if (this.moveEnumConstant) {
            int end2;
            char c2;
            int end1;
            Document document = editor.getDocument();
            CharSequence cs = document.getCharsSequence();
            char c1 = cs.charAt(end1 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info.range1.getEndOffset()));
            if (c1 == (c2 = cs.charAt(end2 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info.range2.getEndOffset()))) || c1 != ',' && c2 != ',') {
                return;
            }
            if (c1 == ';' || c2 == ';') {
                document.replaceString(end1, end1 + 1, (CharSequence)String.valueOf(c2));
                document.replaceString(end2, end2 + 1, (CharSequence)String.valueOf(c1));
            } else if (c1 == ',') {
                document.deleteString(end1, end1 + 1);
                document.insertString(end2 + 1, (CharSequence)",");
            } else {
                document.deleteString(end2, end2 + 1);
                document.insertString(end1 + 1, (CharSequence)",");
            }
        }
    }

    @NotNull
    private static List<PsiElement> getDeclarationAnchors(@NotNull KtDeclaration declaration2) {
        PsiElement nameIdentifier;
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getDeclarationAnchors"));
        }
        final ArrayList<PsiElement> memberSuspects = new ArrayList<PsiElement>();
        KtModifierList modifierList = declaration2.getModifierList();
        if (modifierList != null) {
            memberSuspects.add((PsiElement)modifierList);
        }
        if (declaration2 instanceof KtNamedDeclaration && (nameIdentifier = ((KtNamedDeclaration)declaration2).getNameIdentifier()) != null) {
            memberSuspects.add(nameIdentifier);
        }
        declaration2.accept(new KtVisitorVoid(){

            @Override
            public void visitClassInitializer(@NotNull KtClassInitializer initializer2) {
                if (initializer2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover$1", "visitClassInitializer"));
                }
                PsiElement brace = initializer2.getOpenBraceNode();
                if (brace != null) {
                    memberSuspects.add(brace);
                }
            }

            @Override
            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                KtTypeParameterList typeParameterList;
                if (function2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover$1", "visitNamedFunction"));
                }
                PsiElement equalsToken = function2.getEqualsToken();
                if (equalsToken != null) {
                    memberSuspects.add(equalsToken);
                }
                if ((typeParameterList = function2.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = function2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = function2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            @Override
            public void visitProperty(@NotNull KtProperty property2) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                KtTypeParameterList typeParameterList;
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover$1", "visitProperty"));
                }
                PsiElement valOrVarKeyword = property2.getValOrVarKeyword();
                if (valOrVarKeyword != null) {
                    memberSuspects.add(valOrVarKeyword);
                }
                if ((typeParameterList = property2.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = property2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = property2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }
        });
        ArrayList<PsiElement> arrayList = memberSuspects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getDeclarationAnchors"));
        }
        return arrayList;
    }

    @Nullable
    private static KtDeclaration getMovableDeclaration(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        KtDeclaration declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, KtDeclaration.class, (boolean)false);
        if (declaration2 instanceof KtParameter) {
            return null;
        }
        if (declaration2 instanceof KtTypeParameter) {
            return KotlinDeclarationMover.getMovableDeclaration(declaration2.getParent());
        }
        return PsiTreeUtil.instanceOf((Object)PsiTreeUtil.getParentOfType((PsiElement)declaration2, (Class[])DECLARATION_CONTAINER_CLASSES), (Class[])CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES) ? declaration2 : null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "checkSourceElement"));
        }
        return element2 instanceof KtDeclaration;
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull LineRange oldRange) {
        PsiElement last;
        PsiElement first;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getElementSourceLineRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getElementSourceLineRange"));
        }
        if (oldRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getElementSourceLineRange"));
        }
        if (element2 instanceof KtDeclaration) {
            first = element2.getFirstChild();
            last = element2.getLastChild();
            if (first == null || last == null) {
                return null;
            }
        } else {
            first = last = element2;
        }
        TextRange textRange1 = first.getTextRange();
        TextRange textRange2 = last.getTextRange();
        Document doc = editor.getDocument();
        if (doc.getTextLength() < textRange2.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange1.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange2.getEndOffset()).line + 1;
        if (element2 instanceof PsiComment || startLine == oldRange.startLine || startLine == oldRange.endLine || endLine == oldRange.startLine || endLine == oldRange.endLine) {
            return new LineRange(startLine, endLine);
        }
        TextRange lineTextRange = new TextRange(doc.getLineStartOffset(oldRange.startLine), doc.getLineEndOffset(oldRange.endLine));
        if (element2 instanceof KtDeclaration) {
            for (PsiElement anchor2 : KotlinDeclarationMover.getDeclarationAnchors((KtDeclaration)element2)) {
                TextRange suspectTextRange = anchor2.getTextRange();
                if (suspectTextRange == null || !lineTextRange.intersects(suspectTextRange)) continue;
                return new LineRange(startLine, endLine);
            }
        }
        return null;
    }

    @Nullable
    private static LineRange getTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down, @NotNull PsiElement target) {
        KtClassOrObject ktClassOrObject;
        KtClassBody classBody;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getTargetRange"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "getTargetRange"));
        }
        PsiElement start = sibling;
        PsiElement end = sibling;
        KtClassBody nextParent = null;
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE)) {
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtClassBody)) {
                return null;
            }
            if (target instanceof KtEnumEntry) {
                return null;
            }
            KtClassOrObject ktClassOrObject2 = (KtClassOrObject)parent2.getParent();
            assert (ktClassOrObject2 != null);
            nextParent = ktClassOrObject2.getParent();
            if (!down) {
                start = ktClassOrObject2;
            }
        } else if (sibling instanceof KtClassOrObject && (classBody = (ktClassOrObject = (KtClassOrObject)sibling).getBody()) != null) {
            nextParent = classBody;
            if (!down) {
                start = classBody.getRBrace();
            }
            PsiElement psiElement2 = end = down ? classBody.getLBrace() : classBody.getRBrace();
        }
        if (nextParent != null) {
            if (target instanceof KtAnonymousInitializer && !(nextParent instanceof KtClassBody)) {
                return null;
            }
            if (target instanceof KtEnumEntry) {
                if (!(nextParent instanceof KtClassBody)) {
                    return null;
                }
                KtClassOrObject nextClassOrObject = (KtClassOrObject)nextParent.getParent();
                assert (nextClassOrObject != null);
                if (!nextClassOrObject.hasModifier(KtTokens.ENUM_KEYWORD)) {
                    return null;
                }
            }
        }
        if (target instanceof KtPropertyAccessor && !(sibling instanceof KtPropertyAccessor)) {
            return null;
        }
        return start != null && end != null ? new LineRange(start, end, editor.getDocument()) : null;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "checkAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover", "checkAvailable"));
        }
        if (!super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = KotlinDeclarationMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        KtDeclaration firstDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getFirst());
        if (firstDecl == null) {
            return false;
        }
        this.moveEnumConstant = firstDecl instanceof KtEnumEntry;
        KtDeclaration lastDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getSecond());
        if (lastDecl == null) {
            return false;
        }
        LineRange sourceRange = this.getSourceRange(firstDecl, lastDecl, editor, oldRange);
        if (sourceRange == null) {
            return false;
        }
        PsiElement sibling = KotlinDeclarationMover.getLastNonWhiteSiblingInLine(KotlinDeclarationMover.firstNonWhiteSibling(sourceRange, down), editor, down);
        if (sibling == null) {
            info.toMove2 = null;
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = KotlinDeclarationMover.getTargetRange(editor, sibling, down, sourceRange.firstElement);
        return true;
    }
}

