/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractorUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRangeKt;
import org.jetbrains.kotlin.psi.CopyableUserDataProperty;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.NotNullableCopyableUserDataProperty;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a \u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b\u001a\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013H\u0002\u001a\u0012\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020\u0013H\u0002\u001a\f\u0010,\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\f\u0010-\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\u000e\u0010.\u001a\u0004\u0018\u00010/*\u00020\u0019H\u0002\u001a\f\u00100\u001a\u00020\u001d*\u00020\u0013H\u0002\u001a\f\u00101\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\f\u00102\u001a\u00020\u001d*\u00020\u0015H\u0002\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\"/\u0010\n\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"<set-?>", "Lcom/intellij/psi/PsiElement;", "DEBUG_SMART_CAST", "getDEBUG_SMART_CAST", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "setDEBUG_SMART_CAST", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "DEBUG_SMART_CAST$delegate", "Lorg/jetbrains/kotlin/psi/CopyableUserDataProperty;", "", "IS_CONTEXT_ELEMENT", "getIS_CONTEXT_ELEMENT", "(Lcom/intellij/psi/PsiElement;)Z", "setIS_CONTEXT_ELEMENT", "(Lcom/intellij/psi/PsiElement;Z)V", "IS_CONTEXT_ELEMENT$delegate", "Lorg/jetbrains/kotlin/psi/NotNullableCopyableUserDataProperty;", "addDebugExpressionBeforeContextElement", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "contextElement", "addDebugExpressionIntoTmpFileForExtractFunction", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "addImportsToFile", "", "newImportList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "tmpFile", "findElementBefore", "getExpressionToAddDebugExpressionBefore", "getFunctionForExtractedFragment", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "breakpointFile", "Lcom/intellij/psi/PsiFile;", "breakpointLine", "replaceByLambdaCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "wrapInLambdaCall", "clearContextElement", "clearSmartCasts", "findContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "insertSmartCasts", "markContextElement", "markSmartCasts", "idea"})
public final class ExtractFunctionForDebuggerUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final NotNullableCopyableUserDataProperty IS_CONTEXT_ELEMENT$delegate;
    private static final CopyableUserDataProperty DEBUG_SMART_CAST$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(ExtractFunctionForDebuggerUtilKt.class, (String)"idea"), "IS_CONTEXT_ELEMENT", "getIS_CONTEXT_ELEMENT(Lcom/intellij/psi/PsiElement;)Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(ExtractFunctionForDebuggerUtilKt.class, (String)"idea"), "DEBUG_SMART_CAST", "getDEBUG_SMART_CAST(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;"))};
        Key key = Key.create((String)"IS_CONTEXT_ELEMENT");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"IS_CONTEXT_ELEMENT\")");
        IS_CONTEXT_ELEMENT$delegate = new NotNullableCopyableUserDataProperty(key, false);
        Key key2 = Key.create((String)"DEBUG_SMART_CAST");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_SMART_CAST\")");
        DEBUG_SMART_CAST$delegate = new CopyableUserDataProperty(key2);
    }

    @Nullable
    public static final ExtractionResult getFunctionForExtractedFragment(@NotNull KtCodeFragment codeFragment, @NotNull PsiFile breakpointFile, int breakpointLine) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)breakpointFile, (String)"breakpointFile");
        Function2<org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult, KtFile, String> getErrorMessageForExtractFunctionResult$ = new Function2<org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult, KtFile, String>(breakpointFile, codeFragment, breakpointLine){
            final /* synthetic */ PsiFile $breakpointFile;
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ int $breakpointLine;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult analysisResult, @NotNull KtFile tmpFile) {
                void $receiver$iv$iv;
                Attachment[] $receiver$iv;
                Attachment[] elements$iv;
                AnalysisResult.ErrorMessage item$iv$iv;
                Attachment[] attachmentArray;
                Attachment[] attachmentArray2;
                Intrinsics.checkParameterIsNotNull((Object)analysisResult, (String)"analysisResult");
                Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
                if (KotlinInternalMode.Instance.getEnabled()) {
                    Collection<String> collection;
                    void $receiver$iv$iv2;
                    void $receiver$iv2;
                    Attachment attachment;
                    Attachment[] attachmentArray3 = new Attachment[6];
                    attachmentArray3[0] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)tmpFile);
                    attachmentArray3[1] = AttachmentUtilsKt.attachmentByPsiFile(this.$breakpointFile);
                    attachmentArray3[2] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)this.$codeFragment);
                    attachmentArray3[3] = new Attachment("breakpoint.info", "line: " + this.$breakpointLine);
                    Object object = this.$codeFragment.getContext();
                    if (object == null || (object = object.getText()) == null) {
                        object = "null";
                    }
                    attachmentArray3[4] = new Attachment("context.info", (String)object);
                    Iterable iterable = analysisResult.getMessages();
                    String string = "errors.info";
                    Attachment attachment2 = attachment;
                    Attachment attachment3 = attachment;
                    int n = 5;
                    attachmentArray2 = attachmentArray3;
                    attachmentArray = attachmentArray3;
                    void var5_10 = $receiver$iv2;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    Iterator<T> iterator2 = $receiver$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        AnalysisResult.ErrorMessage errorMessage = item$iv$iv = iterator2.next();
                        collection = destination$iv$iv;
                        String string2 = it + ": " + it.renderMessage();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    attachment2(string, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    attachmentArray2[n] = attachment3;
                    Attachment[] attachments = elements$iv = attachmentArray;
                    KotlinEvaluationBuilderKt.getLOG().error((Object)LogMessageEx.createEvent((String)"Internal error during evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)new Throwable("Extract function fails with " + CollectionsKt.joinToString$default((Iterable)analysisResult.getMessages(), null, null, null, (int)0, null, (Function1)getFunctionForExtractedFragment.1.INSTANCE, (int)31, null))), (Attachment[])new Attachment[]{AttachmentUtilsKt.mergeAttachments(Arrays.copyOf(attachments, attachments.length))}));
                }
                elements$iv = $receiver$iv = (Attachment[])analysisResult.getMessages();
                Attachment[] destination$iv$iv = (Attachment[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv2 : $receiver$iv$iv) {
                    Object object;
                    block18: {
                        String message2;
                        block17: {
                            Object object2;
                            String string;
                            void errorMessage;
                            item$iv$iv = (AnalysisResult.ErrorMessage)((Object)item$iv$iv2);
                            attachmentArray = destination$iv$iv;
                            switch (ExtractFunctionForDebuggerUtilKt$WhenMappings.$EnumSwitchMapping$0[errorMessage.ordinal()]) {
                                case 1: {
                                    string = "Cannot perform an action without an expression";
                                    break;
                                }
                                case 2: {
                                    string = "Cannot perform an action at this breakpoint " + this.$breakpointFile.getName() + ":" + this.$breakpointLine;
                                    break;
                                }
                                case 3: {
                                    string = "Cannot perform an action due to erroneous code";
                                    break;
                                }
                                case 4: {
                                    string = "Cannot perform an action for expression with super call";
                                    break;
                                }
                                case 5: {
                                    string = "Cannot perform an action because following types are unavailable from debugger scope";
                                    break;
                                }
                                case 6: {
                                    string = "Cannot perform an action because this code fragment contains erroneous types";
                                    break;
                                }
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: {
                                    string = "Cannot perform an action for this expression";
                                    break;
                                }
                                case 11: {
                                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected error: " + errorMessage)));
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            message2 = string;
                            object = errorMessage.getAdditionalInfo();
                            if (object == null) break block17;
                            Object it = object2 = object;
                            object = message2 + ": " + CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                            if (object != null) break block18;
                        }
                        object = message2;
                    }
                    attachmentArray2 = object;
                    attachmentArray.add(attachmentArray2);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            }
            {
                this.$breakpointFile = psiFile;
                this.$codeFragment = ktCodeFragment;
                this.$breakpointLine = n;
                super(2);
            }
        };
        Function0<ExtractionResult> generateFunction$ = new Function0<ExtractionResult>(codeFragment, breakpointLine, getErrorMessageForExtractFunctionResult$){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ int $breakpointLine;
            final /* synthetic */ getFunctionForExtractedFragment.1 $getErrorMessageForExtractFunctionResult;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ExtractionResult invoke() {
                ExtractableCodeDescriptorWithConflicts validationResult;
                KtFile ktFile = this.$codeFragment.getContextContainingFile();
                if (ktFile == null) {
                    return null;
                }
                KtFile originalFile = ktFile;
                List<KtExpression> newDebugExpressions = ExtractFunctionForDebuggerUtilKt.addDebugExpressionIntoTmpFileForExtractFunction(originalFile, this.$codeFragment, this.$breakpointLine);
                if (newDebugExpressions.isEmpty()) {
                    return null;
                }
                KtFile tmpFile = ((KtExpression)CollectionsKt.first(newDebugExpressions)).getContainingKtFile();
                if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("TMP_FILE:" + "\n" + (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(tmpFile){
                        final /* synthetic */ KtFile $tmpFile;

                        public final String invoke() {
                            return this.$tmpFile.getText();
                        }
                        {
                            this.$tmpFile = ktFile;
                            super(0);
                        }
                    }));
                }
                KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull(tmpFile.getDeclarations());
                if (ktDeclaration == null) {
                    return null;
                }
                KtDeclaration targetSibling = ktDeclaration;
                ExtractionOptions options2 = new ExtractionOptions(false, true, false, true, true, true, 4, null);
                KtFile ktFile2 = tmpFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"tmpFile");
                org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult analysisResult = ExtractableAnalysisUtilKt.performAnalysis(new ExtractionData(ktFile2, KotlinPsiRangeKt.toRange$default(newDebugExpressions, false, 1, null), targetSibling, null, options2));
                if (Intrinsics.areEqual((Object)((Object)analysisResult.getStatus()), (Object)((Object)AnalysisResult.Status.SUCCESS)) ^ true) {
                    KtFile ktFile3 = tmpFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile3, (String)"tmpFile");
                    EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)this.$getErrorMessageForExtractFunctionResult.invoke(analysisResult, ktFile3));
                    Intrinsics.checkExpressionValueIsNotNull((Object)evaluateException, (String)"EvaluateExceptionUtil.cr\u2026analysisResult, tmpFile))");
                    throw (Throwable)evaluateException;
                }
                ExtractableCodeDescriptor extractableCodeDescriptor = analysisResult.getDescriptor();
                if (extractableCodeDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (!(validationResult = ExtractableAnalysisUtilKt.validate$default(extractableCodeDescriptor, null, 1, null)).getConflicts().isEmpty()) {
                    Collection<String> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Iterable iterable = validationResult.getConflicts().keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("Following declarations are unavailable in debug scope: ");
                    void var9_11 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        PsiElement psiElement2 = (PsiElement)item$iv$iv;
                        collection = destination$iv$iv;
                        String string = it.getText();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)evaluateException, (String)"EvaluateExceptionUtil.cr\u2026xt }.joinToString(\",\")}\")");
                    throw (Throwable)evaluateException;
                }
                ExtractionGeneratorOptions generatorOptions = new ExtractionGeneratorOptions(true, null, KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME(), false, false, 18, null);
                return ExtractorUtilKt.generateDeclaration$default(new ExtractionGeneratorConfiguration(validationResult.getDescriptor(), generatorOptions), null, 1, null);
            }
            {
                this.$codeFragment = ktCodeFragment;
                this.$breakpointLine = n;
                this.$getErrorMessageForExtractFunctionResult = var3_3;
                super(0);
            }
        };
        return (ExtractionResult)ApplicationUtilsKt.runReadAction((Function0)new Function0<ExtractionResult>(generateFunction$){
            final /* synthetic */ getFunctionForExtractedFragment.2 $generateFunction;

            @Nullable
            public final ExtractionResult invoke() {
                return this.$generateFunction.invoke();
            }
            {
                this.$generateFunction = var1_1;
                super(0);
            }
        });
    }

    @NotNull
    public static final List<KtExpression> addDebugExpressionIntoTmpFileForExtractFunction(@NotNull KtFile originalFile, @NotNull KtCodeFragment codeFragment, int line) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        ExtractFunctionForDebuggerUtilKt.markContextElement(codeFragment);
        ExtractFunctionForDebuggerUtilKt.markSmartCasts(codeFragment);
        PsiElement psiElement2 = originalFile.copy();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile tmpFile = (KtFile)psiElement2;
        CodeFragmentUtilKt.setSuppressDiagnosticsInDebugMode(tmpFile, true);
        KtPsiFactoryKt.setAnalysisContext(tmpFile, KtPsiFactoryKt.getAnalysisContext(originalFile));
        PsiElement psiElement3 = ExtractFunctionForDebuggerUtilKt.getExpressionToAddDebugExpressionBefore(tmpFile, (PsiElement)codeFragment.getOriginalContext(), line);
        if (psiElement3 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement contextElement = psiElement3;
        ExtractFunctionForDebuggerUtilKt.addImportsToFile(codeFragment.importsAsImportList(), tmpFile);
        List<KtExpression> contentElementsInTmpFile = ExtractFunctionForDebuggerUtilKt.addDebugExpressionBeforeContextElement(codeFragment, contextElement);
        Iterable $receiver$iv = contentElementsInTmpFile;
        for (Object element$iv : $receiver$iv) {
            KtExpression it = (KtExpression)element$iv;
            ExtractFunctionForDebuggerUtilKt.insertSmartCasts(it);
        }
        ExtractFunctionForDebuggerUtilKt.clearContextElement(codeFragment);
        ExtractFunctionForDebuggerUtilKt.clearSmartCasts(codeFragment);
        return contentElementsInTmpFile;
    }

    private static final boolean getIS_CONTEXT_ELEMENT(@NotNull PsiElement $receiver) {
        return (Boolean)IS_CONTEXT_ELEMENT$delegate.getValue($receiver, $$delegatedProperties[0]);
    }

    private static final void setIS_CONTEXT_ELEMENT(@NotNull PsiElement $receiver, boolean bl) {
        IS_CONTEXT_ELEMENT$delegate.setValue($receiver, $$delegatedProperties[0], bl);
    }

    private static final void markContextElement(@NotNull KtCodeFragment $receiver) {
        block0: {
            KtElement ktElement = $receiver.getOriginalContext();
            if (ktElement == null) break block0;
            ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT((PsiElement)ktElement, true);
        }
    }

    private static final void clearContextElement(@NotNull KtCodeFragment $receiver) {
        block0: {
            KtElement ktElement = $receiver.getOriginalContext();
            if (ktElement == null) break block0;
            ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT((PsiElement)ktElement, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KtElement findContextElement(@NotNull KtFile $receiver) {
        void result$iv$iv;
        void $receiver$iv;
        PsiElement psiElement2 = (PsiElement)$receiver;
        Function1 predicate$iv = findContextElement.1.INSTANCE;
        void $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(PsiElement element2) {
                if (element2 instanceof KtElement && ((Boolean)this.$predicate.invoke((Object)element2)).booleanValue()) {
                    this.$result.element = element2;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element2;
                if (true) {
                    super.visitElement(element2);
                }
            }
        });
        return (KtElement)((PsiElement)result$iv$iv.element);
    }

    private static final PsiElement getDEBUG_SMART_CAST(@NotNull PsiElement $receiver) {
        return (PsiElement)DEBUG_SMART_CAST$delegate.getValue($receiver, $$delegatedProperties[1]);
    }

    private static final void setDEBUG_SMART_CAST(@NotNull PsiElement $receiver, PsiElement psiElement2) {
        DEBUG_SMART_CAST$delegate.setValue($receiver, $$delegatedProperties[1], psiElement2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void markSmartCasts(@NotNull KtCodeFragment $receiver) {
        block0: {
            void $receiver$iv;
            BindingContext bindingContext2 = ((AnalysisResult)ProgressUtilKt.runInReadActionWithWriteActionPriority((Function0)new Function0<AnalysisResult>($receiver){
                final /* synthetic */ KtCodeFragment receiver$0;

                @NotNull
                public final AnalysisResult invoke() {
                    return ResolutionUtils.analyzeFullyAndGetResult(this.receiver$0, new KtFile[0]);
                }
                {
                    this.receiver$0 = ktCodeFragment;
                    super(0);
                }
            })).getBindingContext();
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            KtElement ktElement = $receiver.getContentElement();
            if (ktElement == null) break block0;
            PsiElement psiElement2 = (PsiElement)ktElement;
            Function1 action$iv = (Function1)new Function1<KtExpression, Unit>(bindingContext2, factory2){
                final /* synthetic */ BindingContext $bindingContext;
                final /* synthetic */ KtPsiFactory $factory;

                public final void invoke(@NotNull KtExpression expression2) {
                    KotlinType smartCast;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    ExplicitSmartCasts explicitSmartCasts = (ExplicitSmartCasts)this.$bindingContext.get(BindingContext.SMARTCAST, expression2);
                    KotlinType kotlinType = smartCast = explicitSmartCasts != null ? explicitSmartCasts.getDefaultType() : null;
                    if (smartCast != null) {
                        KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default(this.$factory, "(" + "$" + "0 as " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(smartCast) + ")", new Object[]{expression2}, false, 4, null);
                        if (ktExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        KtParenthesizedExpression smartCastedExpression = (KtParenthesizedExpression)ktExpression;
                        ExtractFunctionForDebuggerUtilKt.access$setDEBUG_SMART_CAST$p((PsiElement)expression2, (PsiElement)smartCastedExpression);
                    }
                }
                {
                    this.$bindingContext = bindingContext2;
                    this.$factory = ktPsiFactory;
                    super(1);
                }
            };
            void $receiver$iv$iv = $receiver$iv;
            $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(PsiElement element2) {
                    PsiElement it = element2;
                    if (true) {
                        super.visitElement(element2);
                    }
                    if (element2 instanceof KtExpression) {
                        this.$action.invoke((Object)element2);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void insertSmartCasts(@NotNull KtExpression $receiver) {
        void $receiver$iv;
        PsiElement psiElement2 = (PsiElement)$receiver;
        Function1 action$iv = insertSmartCasts.1.INSTANCE;
        void $receiver$iv$iv = $receiver$iv;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(PsiElement element2) {
                PsiElement it = element2;
                if (true) {
                    super.visitElement(element2);
                }
                if (element2 instanceof KtExpression) {
                    this.$action.invoke((Object)element2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void clearSmartCasts(@NotNull KtCodeFragment $receiver) {
        block0: {
            void $receiver$iv;
            KtElement ktElement = $receiver.getContentElement();
            if (ktElement == null) break block0;
            PsiElement psiElement2 = (PsiElement)ktElement;
            Function1 action$iv = clearSmartCasts.1.INSTANCE;
            void $receiver$iv$iv = $receiver$iv;
            $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(PsiElement element2) {
                    PsiElement it = element2;
                    if (true) {
                        super.visitElement(element2);
                    }
                    if (element2 instanceof KtExpression) {
                        this.$action.invoke((Object)element2);
                    }
                }
            });
        }
    }

    private static final void addImportsToFile(KtImportList newImportList, KtFile tmpFile) {
        Collection collection;
        if (newImportList != null && !(collection = (Collection)newImportList.getImports()).isEmpty()) {
            KtImportList tmpFileImportList = tmpFile.getImportList();
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)tmpFile, false, 2, null);
            if (tmpFileImportList == null) {
                KtPackageDirective packageDirective = tmpFile.getPackageDirective();
                tmpFile.addAfter(psiFactory.createNewLine(), packageDirective);
                tmpFile.addAfter((PsiElement)newImportList, tmpFile.getPackageDirective());
            } else {
                Iterable $receiver$iv = newImportList.getImports();
                for (Object element$iv : $receiver$iv) {
                    KtImportDirective it = (KtImportDirective)element$iv;
                    tmpFileImportList.add(psiFactory.createNewLine());
                    tmpFileImportList.add((PsiElement)it);
                }
                tmpFileImportList.add(psiFactory.createNewLine());
            }
        }
    }

    private static final PsiElement getExpressionToAddDebugExpressionBefore(KtFile tmpFile, PsiElement contextElement, int line) {
        PsiElement parentOfParent;
        PsiElement parent2;
        KtElement elementAt;
        if (contextElement == null) {
            Integer lineStart;
            Integer n = CodeInsightUtils.getStartLineOffset((PsiFile)tmpFile, line);
            if (n == null) {
                return null;
            }
            Integer n2 = lineStart = n;
            Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"lineStart");
            PsiElement psiElement2 = tmpFile.findElementAt(n2);
            if (psiElement2 == null) {
                return null;
            }
            PsiElement elementAtOffset = psiElement2;
            Integer n3 = lineStart;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"lineStart");
            PsiElement psiElement3 = CodeInsightUtils.getTopmostElementAtOffset(elementAtOffset, n3);
            if (psiElement3 == null) {
                psiElement3 = elementAtOffset;
            }
            return psiElement3;
        }
        getExpressionToAddDebugExpressionBefore.1 shouldStop$ = getExpressionToAddDebugExpressionBefore.1.INSTANCE;
        KtElement ktElement = elementAt = ExtractFunctionForDebuggerUtilKt.findContextElement(tmpFile);
        Object object = parent2 = ktElement != null ? ktElement.getParent() : null;
        if (shouldStop$.invoke((PsiElement)elementAt, parent2)) {
            return (PsiElement)elementAt;
        }
        PsiElement psiElement4 = parent2;
        Object object2 = parentOfParent = psiElement4 != null ? psiElement4.getParent() : null;
        while (parent2 != null && parentOfParent != null && !shouldStop$.invoke(parent2, parentOfParent)) {
            PsiElement psiElement5 = parent2 = parent2.getParent();
            parentOfParent = psiElement5 != null ? psiElement5.getParent() : null;
        }
        return parent2;
    }

    private static final List<KtExpression> addDebugExpressionBeforeContextElement(KtCodeFragment codeFragment, PsiElement contextElement) {
        PsiFile containingFile;
        PsiElement elementBefore = ExtractFunctionForDebuggerUtilKt.findElementBefore(contextElement);
        PsiElement psiElement2 = elementBefore;
        if (psiElement2 == null || (psiElement2 = psiElement2.getParent()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent2 = psiElement2;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)codeFragment, false, 2, null);
        parent2.addBefore(psiFactory.createNewLine(), elementBefore);
        Function1<KtElement, List<? extends KtExpression>> insertExpression$ = new Function1<KtElement, List<? extends KtExpression>>(parent2, elementBefore, psiFactory){
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ PsiElement $elementBefore;
            final /* synthetic */ KtPsiFactory $psiFactory;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<KtExpression> invoke(@Nullable KtElement expr) {
                KtElement ktElement = expr;
                if (ktElement instanceof KtBlockExpression) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)((KtBlockExpression)expr).getStatements();
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        KtElement p1 = (KtElement)element$iv$iv;
                        Iterable list$iv$iv = this.invoke(p1);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                if (ktElement instanceof KtExpression) {
                    PsiElement newDebugExpression = this.$parent.addBefore((PsiElement)expr, this.$elementBefore);
                    if (newDebugExpression == null) {
                        KotlinEvaluationBuilderKt.getLOG().error("Couldn't insert debug expression " + ((KtExpression)expr).getText() + " to context file before " + this.$elementBefore.getText());
                        return CollectionsKt.emptyList();
                    }
                    this.$parent.addBefore(this.$psiFactory.createNewLine(), this.$elementBefore);
                    return CollectionsKt.listOf((Object)((KtExpression)newDebugExpression));
                }
                return CollectionsKt.emptyList();
            }
            {
                this.$parent = psiElement2;
                this.$elementBefore = psiElement3;
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        };
        PsiElement psiElement3 = codeFragment.getContext();
        Object object = containingFile = psiElement3 != null ? psiElement3.getContainingFile() : null;
        if (containingFile instanceof KtCodeFragment) {
            KtElement ktElement = ((KtCodeFragment)containingFile).getContentElement();
            if (!(ktElement instanceof KtExpression)) {
                ktElement = null;
            }
            insertExpression$.invoke((KtElement)((KtExpression)ktElement));
        }
        KtElement ktElement = codeFragment.getContentElement();
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement debugExpression = ktElement;
        return insertExpression$.invoke(debugExpression);
    }

    private static final PsiElement findElementBefore(PsiElement contextElement) {
        PsiElement psiElement2;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(contextElement, false, 2, null);
        Function1<KtClassBody, PsiElement> insertNewInitializer$ = new Function1<KtClassBody, PsiElement>(psiFactory){
            final /* synthetic */ KtPsiFactory $psiFactory;

            @Nullable
            public final PsiElement invoke(@NotNull KtClassBody classBody) {
                KtBlockExpression block;
                Intrinsics.checkParameterIsNotNull((Object)classBody, (String)"classBody");
                KtAnonymousInitializer initializer2 = this.$psiFactory.createAnonymousInitializer();
                PsiElement psiElement2 = classBody.addAfter(initializer2, classBody.getFirstChild());
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnonymousInitializer");
                }
                KtAnonymousInitializer newInitializer = (KtAnonymousInitializer)psiElement2;
                KtBlockExpression ktBlockExpression = block = (KtBlockExpression)newInitializer.getBody();
                return ktBlockExpression != null ? ktBlockExpression.getLastChild() : null;
            }
            {
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        };
        if (contextElement instanceof KtFile) {
            KtNamedFunction fakeFunction = psiFactory.createFunction("fun _debug_fun_() {}");
            contextElement.add(psiFactory.createNewLine());
            PsiElement psiElement3 = contextElement.add((PsiElement)fakeFunction);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtNamedFunction newFakeFun = (KtNamedFunction)psiElement3;
            KtExpression ktExpression = newFakeFun.getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            psiElement2 = ktExpression.getLastChild();
        } else if (contextElement instanceof KtProperty && !((KtProperty)contextElement).isLocal()) {
            KtExpression delegateExpressionOrInitializer = ((KtProperty)contextElement).getDelegateExpressionOrInitializer();
            if (delegateExpressionOrInitializer != null) {
                psiElement2 = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(delegateExpressionOrInitializer);
            } else {
                KtPropertyAccessor getter;
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)contextElement).getGetter();
                if (ktPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                if (!(getter = ktPropertyAccessor).hasBlockBody()) {
                    KtExpression ktExpression = getter.getBodyExpression();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"getter.bodyExpression!!");
                    psiElement2 = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(ktExpression);
                } else {
                    KtExpression ktExpression = getter.getBodyExpression();
                    if (ktExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                    }
                    psiElement2 = (PsiElement)CollectionsKt.first(((KtBlockExpression)ktExpression).getStatements());
                }
            }
        } else if (contextElement instanceof KtParameter) {
            KtFunction ownerFunction;
            KtFunction ktFunction = ((KtParameter)contextElement).getOwnerFunction();
            if (ktFunction == null) {
                Intrinsics.throwNpe();
            }
            KtFunction ktFunction2 = ownerFunction = ktFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"ownerFunction");
            psiElement2 = ExtractFunctionForDebuggerUtilKt.findElementBefore(ktFunction2);
        } else if (contextElement instanceof KtPrimaryConstructor) {
            KtClassOrObject classOrObject = ((KtPrimaryConstructor)contextElement).getContainingClassOrObject();
            psiElement2 = insertNewInitializer$.invoke(KtClassOrObjectKt.getOrCreateBody(classOrObject));
        } else if (contextElement instanceof KtClassOrObject) {
            psiElement2 = insertNewInitializer$.invoke(KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)contextElement));
        } else if (contextElement instanceof KtFunctionLiteral) {
            KtBlockExpression ktBlockExpression = ((KtFunctionLiteral)contextElement).getBodyExpression();
            if (ktBlockExpression == null) {
                Intrinsics.throwNpe();
            }
            KtBlockExpression block = ktBlockExpression;
            KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull(block.getStatements());
            psiElement2 = ktExpression != null ? (PsiElement)ktExpression : block.getLastChild();
        } else if (contextElement instanceof KtDeclarationWithBody && !((KtDeclarationWithBody)contextElement).hasBody()) {
            KtBlockExpression block = psiFactory.createBlock("");
            PsiElement psiElement4 = contextElement.add((PsiElement)block);
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            }
            KtBlockExpression newBlock = (KtBlockExpression)psiElement4;
            psiElement2 = newBlock.getRBrace();
        } else if (contextElement instanceof KtDeclarationWithBody && !((KtDeclarationWithBody)contextElement).hasBlockBody()) {
            KtExpression ktExpression = ((KtDeclarationWithBody)contextElement).getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"contextElement.bodyExpression!!");
            psiElement2 = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(ktExpression);
        } else if (contextElement instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)contextElement).hasBlockBody()) {
            KtExpression ktExpression = ((KtDeclarationWithBody)contextElement).getBodyExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            }
            KtBlockExpression block = (KtBlockExpression)ktExpression;
            KtExpression last = (KtExpression)CollectionsKt.lastOrNull(block.getStatements());
            KtExpression ktExpression2 = last;
            if (!(ktExpression2 instanceof KtReturnExpression)) {
                ktExpression2 = null;
            }
            KtReturnExpression ktReturnExpression = (KtReturnExpression)ktExpression2;
            psiElement2 = ktReturnExpression != null ? (PsiElement)ktReturnExpression : block.getRBrace();
        } else if (contextElement instanceof KtWhenEntry) {
            KtExpression entryExpression = ((KtWhenEntry)contextElement).getExpression();
            if (entryExpression instanceof KtBlockExpression) {
                KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull(((KtBlockExpression)entryExpression).getStatements());
                psiElement2 = ktExpression != null ? (PsiElement)ktExpression : ((KtBlockExpression)entryExpression).getLastChild();
            } else {
                KtExpression ktExpression = entryExpression;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"entryExpression!!");
                psiElement2 = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(ktExpression);
            }
        } else {
            psiElement2 = contextElement;
        }
        return psiElement2;
    }

    private static final KtCallExpression replaceByLambdaCall(KtExpression expression2) {
        Object object;
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null).createExpression("{ " + "\n" + expression2.getText() + " " + "\n" + "}()");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        PsiElement $receiver$iv = (PsiElement)expression2;
        KtCallExpression callExpression2 = (KtCallExpression)ktExpression;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)callExpression2);
        if (result$iv instanceof KtCallExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            object = (KtCallExpression)ktExpression2;
        }
        return (KtCallExpression)object;
    }

    private static final PsiElement wrapInLambdaCall(KtExpression expression2) {
        KtExpression ktExpression;
        KtCallExpression replacedBody = ExtractFunctionForDebuggerUtilKt.replaceByLambdaCall(expression2);
        KtExpression ktExpression2 = replacedBody.getCalleeExpression();
        if (!(ktExpression2 instanceof KtLambdaExpression)) {
            ktExpression2 = null;
        }
        return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getBodyExpression()) != null ? ktExpression.getFirstChild() : null;
    }

    public static final /* synthetic */ boolean access$getIS_CONTEXT_ELEMENT$p(@NotNull PsiElement $receiver) {
        return ExtractFunctionForDebuggerUtilKt.getIS_CONTEXT_ELEMENT($receiver);
    }

    public static final /* synthetic */ void access$setIS_CONTEXT_ELEMENT$p(@NotNull PsiElement $receiver, boolean bl) {
        ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT($receiver, bl);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$getDEBUG_SMART_CAST$p(@NotNull PsiElement $receiver) {
        return ExtractFunctionForDebuggerUtilKt.getDEBUG_SMART_CAST($receiver);
    }

    public static final /* synthetic */ void access$setDEBUG_SMART_CAST$p(@NotNull PsiElement $receiver, @Nullable PsiElement psiElement2) {
        ExtractFunctionForDebuggerUtilKt.setDEBUG_SMART_CAST($receiver, psiElement2);
    }
}

