/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClassFileDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "()V", "stubBuilder", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder;", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createFileViewProvider", "Lorg/jetbrains/kotlin/idea/decompiler/KotlinDecompiledFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "getStubBuilder", "idea-analysis"})
public final class KotlinClassFileDecompiler
extends ClassFileDecompilers.Full {
    private final KotlinClsStubBuilder stubBuilder = new KotlinClsStubBuilder();

    public boolean accepts(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return IDEKotlinBinaryClassCache.INSTANCE.isKotlinJvmCompiledFile(file2);
    }

    @NotNull
    public KotlinClsStubBuilder getStubBuilder() {
        return this.stubBuilder;
    }

    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file2, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Project project = manager.getProject();
        return new KotlinDecompiledFileViewProvider(manager, file2, physical, (Function1<? super KotlinDecompiledFileViewProvider, ? extends KtDecompiledFile>)((Function1)new Function1<KotlinDecompiledFileViewProvider, KtDecompiledFile>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final KtDecompiledFile invoke(@NotNull KotlinDecompiledFileViewProvider provider2) {
                KtDecompiledFile ktDecompiledFile;
                Intrinsics.checkParameterIsNotNull((Object)((Object)provider2), (String)"provider");
                VirtualFile virtualFile2 = provider2.getVirtualFile();
                FileIndexFacade fileIndex = (FileIndexFacade)ServiceManager.getService((Project)this.$project, FileIndexFacade.class);
                if (!fileIndex.isInLibraryClasses(virtualFile2) && fileIndex.isInSource(virtualFile2)) {
                    ktDecompiledFile = null;
                } else {
                    VirtualFile virtualFile3 = virtualFile2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                    ktDecompiledFile = ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile3) ? null : (KtDecompiledFile)new KtClsFile(provider2);
                }
                return ktDecompiledFile;
            }
            {
                this.$project = project;
                super(1);
            }
        }));
    }
}

