/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FrameworksCompatibilityUtils {
    private FrameworksCompatibilityUtils() {
    }

    public static void suggestRemoveIncompatibleFramework(@NotNull ModifiableRootModel rootModel, @NotNull Set<? extends LibraryKind> frameworkLibraryKinds, @NotNull FrameworkType frameworkType) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/kotlin/idea/framework/FrameworksCompatibilityUtils", "suggestRemoveIncompatibleFramework"));
        }
        if (frameworkLibraryKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkLibraryKinds", "org/jetbrains/kotlin/idea/framework/FrameworksCompatibilityUtils", "suggestRemoveIncompatibleFramework"));
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "org/jetbrains/kotlin/idea/framework/FrameworksCompatibilityUtils", "suggestRemoveIncompatibleFramework"));
        }
        ArrayList<OrderEntry> existingEntries = new ArrayList<OrderEntry>();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null) continue;
            for (LibraryKind libraryKind : frameworkLibraryKinds) {
                if (!LibraryPresentationManager.getInstance().isLibraryOfKind(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), libraryKind)) continue;
                existingEntries.add(entry);
            }
        }
        FrameworksCompatibilityUtils.removeWithConfirm(rootModel, existingEntries, String.format("Current module is already configured with '%s' framework.\nDo you want to remove it?", frameworkType.getPresentableName()), "Framework Conflict");
    }

    private static void removeWithConfirm(ModifiableRootModel rootModel, List<OrderEntry> orderEntries, String message2, String title) {
        int result2;
        if (!orderEntries.isEmpty() && (result2 = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon())) == 0) {
            for (OrderEntry entry : orderEntries) {
                rootModel.removeOrderEntry(entry);
            }
        }
    }
}

