/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a5\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0010\b\u0000\u0010\u000b*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0017\u001a\u00020\u0018\"\u0010\b\u0000\u0010\u000b*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"GRADLE_SYSTEM_ID", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getGRADLE_SYSTEM_ID", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "MAVEN_SYSTEM_ID", "getJsStdLibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "getJsStdLibSrcJar", "getLibraryProperties", "LP", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "", "provider", "Lcom/intellij/openapi/roots/libraries/LibraryPresentationProvider;", "(Lcom/intellij/openapi/roots/libraries/LibraryPresentationProvider;Lcom/intellij/openapi/roots/libraries/Library;)Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "getReflectJar", "getRuntimeJar", "getRuntimeSrcJar", "classesRoots", "", "getTestJar", "isDetected", "", "isExternalLibrary", "idea"})
public final class KotlinLibraryUtilKt {
    private static final ProjectSystemId MAVEN_SYSTEM_ID = new ProjectSystemId("MAVEN");
    @NotNull
    private static final ProjectSystemId GRADLE_SYSTEM_ID = new ProjectSystemId("GRADLE");

    public static final <LP extends LibraryProperties<? extends Object>> boolean isDetected(@NotNull LibraryPresentationProvider<LP> provider2, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return KotlinLibraryUtilKt.getLibraryProperties(provider2, library) != null;
    }

    @Nullable
    public static final <LP extends LibraryProperties<? extends Object>> LP getLibraryProperties(@NotNull LibraryPresentationProvider<LP> provider2, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        return (LP)provider2.detect(Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length)));
    }

    @NotNull
    public static final ProjectSystemId getGRADLE_SYSTEM_ID() {
        return GRADLE_SYSTEM_ID;
    }

    private static final boolean isExternalLibrary(Library library) {
        return ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)ProjectSystemId.IDE) || ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)GRADLE_SYSTEM_ID) || ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)MAVEN_SYSTEM_ID);
    }

    @Nullable
    public static final VirtualFile getRuntimeJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        return JavaRuntimeDetectionUtil.getRuntimeJar(Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length)));
    }

    @Nullable
    public static final VirtualFile getReflectJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        List<VirtualFile> list2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*library.g\u2026s(OrderRootType.CLASSES))");
        return LibraryUtils.getJarFile(list2, "kotlin-reflect.jar");
    }

    @Nullable
    public static final VirtualFile getRuntimeSrcJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.SOURCES);
        List<VirtualFile> list2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*library.g\u2026s(OrderRootType.SOURCES))");
        return KotlinLibraryUtilKt.getRuntimeSrcJar(list2);
    }

    @Nullable
    public static final VirtualFile getTestJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        List<VirtualFile> list2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*library.g\u2026s(OrderRootType.CLASSES))");
        return LibraryUtils.getJarFile(list2, "kotlin-test.jar");
    }

    @Nullable
    public static final VirtualFile getJsStdLibJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        List<VirtualFile> list2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*library.g\u2026s(OrderRootType.CLASSES))");
        return LibraryUtils.getJarFile(list2, "kotlin-stdlib-js.jar");
    }

    @Nullable
    public static final VirtualFile getJsStdLibSrcJar(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.SOURCES);
        List<VirtualFile> list2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*library.g\u2026s(OrderRootType.SOURCES))");
        return LibraryUtils.getJarFile(list2, "kotlin-stdlib-js-sources.jar");
    }

    private static final VirtualFile getRuntimeSrcJar(List<? extends VirtualFile> classesRoots) {
        return LibraryUtils.getJarFile(classesRoots, "kotlin-runtime-sources.jar");
    }
}

