/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

public class DebugInfoAnnotator
implements Annotator {
    public static boolean isDebugInfoEnabled() {
        return KotlinInternalMode.Instance.getEnabled();
    }

    public void annotate(@NotNull PsiElement element2, final @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator", "annotate"));
        }
        if (!DebugInfoAnnotator.isDebugInfoEnabled() || !ProjectRootsUtil.isInProjectOrLibSource(element2)) {
            return;
        }
        if (element2 instanceof KtFile && !(element2 instanceof KtCodeFragment)) {
            KtFile file2 = (KtFile)element2;
            try {
                BindingContext bindingContext2 = ResolutionUtils.analyzeFully(file2);
                DebugInfoUtil.markDebugAnnotations((PsiElement)file2, bindingContext2, new DebugInfoUtil.DebugInfoReporter(){

                    @Override
                    public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportElementWithErrorType"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Resolved to error element").setTextAttributes(KotlinHighlightingColors.RESOLVED_TO_ERROR);
                    }

                    @Override
                    public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportMissingUnresolved"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference is not resolved to anything, but is not marked unresolved").setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }

                    @Override
                    public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
                        if (expression2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportUnresolvedWithTarget"));
                        }
                        if (target == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$1", "reportUnresolvedWithTarget"));
                        }
                        holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference marked as unresolved is actually resolved to " + target).setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                holder.createErrorAnnotation(element2, e.getClass().getCanonicalName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

