/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "startInWriteAction", "", "Equals", "HashCode", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "idea"})
public abstract class GenerateEqualsOrHashCodeFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
            return;
        }
        PsiElement psiElement2 = descriptor2.getPsiElement().getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
        }
        new KotlinGenerateEqualsAndHashcodeAction().doInvoke(project, null, (KtClass)psiElement2);
    }

    private GenerateEqualsOrHashCodeFix() {
    }

    public /* synthetic */ GenerateEqualsOrHashCodeFix(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "()V", "getName", "", "idea"})
    public static final class Equals
    extends GenerateEqualsOrHashCodeFix {
        public static final Equals INSTANCE;

        @NotNull
        public String getName() {
            return "Generate 'equals()'";
        }

        private Equals() {
            super(null);
            INSTANCE = this;
        }

        static {
            new Equals();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "()V", "getName", "", "idea"})
    public static final class HashCode
    extends GenerateEqualsOrHashCodeFix {
        public static final HashCode INSTANCE;

        @NotNull
        public String getName() {
            return "Generate 'hashCode()'";
        }

        private HashCode() {
            super(null);
            INSTANCE = this;
        }

        static {
            new HashCode();
        }
    }
}

