/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "caretOffset", "", "Companion", "idea"})
public final class ConvertToBlockBodyIntention
extends SelfTargetingIntention<KtDeclarationWithBody>
implements LowPriorityAction {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtDeclarationWithBody element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2 instanceof KtFunctionLiteral || element2.hasBlockBody() || !element2.hasBody()) {
            return false;
        }
        KtDeclarationWithBody ktDeclarationWithBody = element2;
        if (ktDeclarationWithBody instanceof KtNamedFunction) {
            KotlinType kotlinType = ConvertToBlockBodyIntention.Companion.returnType((KtNamedFunction)element2);
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            return element2.hasDeclaredReturnType() || !returnType2.isError();
        }
        if (ktDeclarationWithBody instanceof KtPropertyAccessor) {
            return true;
        }
        String string = "Unknown declaration type: " + element2;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return !(element2 instanceof KtDeclaration) && super.allowCaretInsideElement(element2);
    }

    @Override
    public void applyTo(@NotNull KtDeclarationWithBody element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Companion.convert(element2);
    }

    public ConvertToBlockBodyIntention() {
        super(KtDeclarationWithBody.class, "Convert to block body", null, 4, null);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention$Companion;", "", "()V", "convert", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "declaration", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "idea"})
    public static final class Companion {
        @NotNull
        public final KtDeclarationWithBody convert(@NotNull KtDeclarationWithBody declaration2) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            KtExpression ktExpression2 = declaration2.getBodyExpression();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            KtExpression body2 = ktExpression2;
            Function1<Boolean, KtExpression> generateBody$ = new Function1<Boolean, KtExpression>(body2, declaration2){
                final /* synthetic */ KtExpression $body;
                final /* synthetic */ KtDeclarationWithBody $declaration;

                @NotNull
                public final KtExpression invoke(boolean returnsValue) {
                    KtExpression ktExpression;
                    boolean needReturn;
                    Collection collection;
                    KotlinType bodyType = ResolutionUtils.analyze$default(this.$body, null, 1, null).getType(this.$body);
                    KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default(this.$declaration, false, 2, null);
                    if (bodyType != null && TypeUtilsKt.isUnit(bodyType) && this.$body instanceof KtNameReferenceExpression) {
                        return factory2.createEmptyBody();
                    }
                    boolean unitWhenAsResult = (bodyType == null || TypeUtilsKt.isUnit(bodyType)) && !(collection = (Collection)UtilsKt.resultingWhens(this.$body)).isEmpty();
                    boolean bl = needReturn = returnsValue && (bodyType == null || !TypeUtilsKt.isUnit(bodyType) && !TypeUtilsKt.isNothing(bodyType));
                    if (needReturn || unitWhenAsResult) {
                        Object[] objectArray = new Object[1];
                        KtExpression ktExpression2 = this.$body;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"body");
                        objectArray[0] = ktExpression2;
                        ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "return $0", objectArray, false, 4, null);
                    } else {
                        KtExpression ktExpression3 = this.$body;
                        ktExpression = ktExpression3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"body");
                    }
                    KtExpression statement = ktExpression;
                    return factory2.createSingleStatementBlock(statement);
                }
                {
                    this.$body = ktExpression;
                    this.$declaration = ktDeclarationWithBody;
                    super(1);
                }
            };
            KtDeclarationWithBody ktDeclarationWithBody = declaration2;
            if (ktDeclarationWithBody instanceof KtNamedFunction) {
                KotlinType kotlinType = this.returnType((KtNamedFunction)declaration2);
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType returnType2 = kotlinType;
                if (!declaration2.hasDeclaredReturnType() && !TypeUtilsKt.isUnit(returnType2)) {
                    PsiModificationUtilsKt.setType$default((KtCallableDeclaration)((Object)declaration2), returnType2, false, 2, null);
                }
                ktExpression = generateBody$.invoke(!TypeUtilsKt.isUnit(returnType2) && !TypeUtilsKt.isNothing(returnType2));
            } else if (ktDeclarationWithBody instanceof KtPropertyAccessor) {
                ktExpression = generateBody$.invoke(((KtPropertyAccessor)declaration2).isGetter());
            } else {
                throw (Throwable)new RuntimeException("Unknown declaration type: " + declaration2);
            }
            KtExpression newBody = ktExpression;
            PsiElement psiElement2 = declaration2.getEqualsToken();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement2.delete();
            body2.replace((PsiElement)newBody);
            return declaration2;
        }

        private final KotlinType returnType(@NotNull KtNamedFunction $receiver) {
            DeclarationDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL).get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            return ((FunctionDescriptor)declarationDescriptor2).getReturnType();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

