/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitSuperQualifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "toNonQualified", "superExpression", "idea"})
public final class RemoveExplicitSuperQualifierIntention
extends SelfTargetingRangeIntention<KtSuperExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtSuperExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getSuperTypeQualifier() == null) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(element2);
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze(selector, BodyResolveMode.PARTIAL);
        if (CallUtilKt.getResolvedCall(selector, bindingContext2) == null) {
            return null;
        }
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element2, false, 2, null), "$0.$1", new Object[]{this.toNonQualified(element2), selector}, false, 4, null);
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression newQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)newQualifiedExpression, (KtExpression)qualifiedExpression, bindingContext2, null, null, null, 28, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(newQualifiedExpression.getSelectorExpression(), newBindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> newResolvedCall = resolvedCall2;
        if (ErrorUtils.isError(newResolvedCall.getResultingDescriptor())) {
            return null;
        }
        KtContainerNode ktContainerNode = element2.getLabelQualifier();
        return new TextRange(PsiUtilsKt.getEndOffset((PsiElement)element2.getInstanceReference()), ktContainerNode != null ? PsiUtilsKt.getStartOffset((PsiElement)ktContainerNode) : PsiUtilsKt.getEndOffset((PsiElement)element2));
    }

    @Override
    public void applyTo(@NotNull KtSuperExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        element2.replace((PsiElement)this.toNonQualified(element2));
    }

    private final KtSuperExpression toNonQualified(KtSuperExpression superExpression) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)superExpression, false, 2, null);
        Name labelName = superExpression.getLabelNameAsName();
        KtExpression ktExpression = labelName != null ? CreateByPatternKt.createExpressionByPattern$default(factory2, "super@$0", new Object[]{labelName}, false, 4, null) : factory2.createExpression("super");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperExpression");
        }
        return (KtSuperExpression)ktExpression;
    }

    public RemoveExplicitSuperQualifierIntention() {
        super(KtSuperExpression.class, "Remove explicit supertype qualification", null, 4, null);
    }
}

