/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.java;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.java.UnimplementedKotlinInterfaceMemberAnnotator;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "findUnimplementedMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "registerFixes", "errorAnnotation", "Lcom/intellij/lang/annotation/Annotation;", "report", "method", "idea-analysis"})
public final class UnimplementedKotlinInterfaceMemberAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        block3: {
            KtLightMethod ktLightMethod;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            if (!(element2 instanceof PsiClass) || Intrinsics.areEqual((Object)((PsiClass)element2).getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE))) {
                return;
            }
            if (((PsiClass)element2).isInterface() || ((PsiClass)element2).hasModifierProperty("abstract")) {
                return;
            }
            if (ClassUtil.getAnyMethodToImplement((PsiClass)((PsiClass)element2)) != null) {
                return;
            }
            KtLightMethod ktLightMethod2 = this.findUnimplementedMethod((PsiClass)element2);
            if (ktLightMethod2 == null) break block3;
            KtLightMethod it = ktLightMethod = ktLightMethod2;
            this.report(it, holder, (PsiClass)element2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightMethod findUnimplementedMethod(PsiClass psiClass2) {
        Object v3;
        block8: {
            Object v0;
            List signaturesFromKotlinInterfaces;
            block7: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)psiClass2.getVisibleSignatures();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    HierarchicalMethodSignature signature = (HierarchicalMethodSignature)element$iv$iv;
                    PsiMethod psiMethod2 = signature.getMethod();
                    PsiMethod it = psiMethod2;
                    if (!(it instanceof KtLightMethod && it.hasModifierProperty("default"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                if ($receiver$iv.isEmpty()) {
                    return null;
                }
                signaturesFromKotlinInterfaces = (List)$receiver$iv;
                Sequence $receiver$iv2 = SequencesKt.generateSequence((Object)psiClass2, (Function1)findUnimplementedMethod.kotlinSuperClass.1.INSTANCE);
                for (Object element$iv : $receiver$iv2) {
                    PsiClass it = (PsiClass)element$iv;
                    if (!(it instanceof KtLightClassForSourceDeclaration)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            PsiClass psiClass3 = v0;
            if (psiClass3 == null) {
                PsiMethod psiMethod3 = ((HierarchicalMethodSignature)CollectionsKt.first((List)signaturesFromKotlinInterfaces)).getMethod();
                if (!(psiMethod3 instanceof KtLightMethod)) {
                    psiMethod3 = null;
                }
                return (KtLightMethod)psiMethod3;
            }
            PsiClass kotlinSuperClass2 = psiClass3;
            Collection signaturesVisibleThroughKotlinSuperClass = kotlinSuperClass2.getVisibleSignatures();
            Iterable $receiver$iv = signaturesFromKotlinInterfaces;
            for (Object element$iv : $receiver$iv) {
                HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv;
                if (!(signaturesVisibleThroughKotlinSuperClass.contains(it) ^ true)) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = v3;
        Object object = hierarchicalMethodSignature != null ? hierarchicalMethodSignature.getMethod() : null;
        if (!(object instanceof KtLightMethod)) {
            object = null;
        }
        return (KtLightMethod)object;
    }

    private final void report(KtLightMethod method, AnnotationHolder holder, PsiClass psiClass2) {
        Annotation errorAnnotation;
        String key = psiClass2 instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
        String message2 = JavaErrorMessages.message((String)key, (Object[])new Object[]{HighlightUtil.formatClass((PsiClass)psiClass2, (boolean)false), JavaHighlightUtil.formatMethod((PsiMethod)((PsiMethod)method)), HighlightUtil.formatClass((PsiClass)method.getContainingClass(), (boolean)false)});
        Annotation annotation2 = errorAnnotation = holder.createErrorAnnotation(HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)psiClass2), message2);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"errorAnnotation");
        this.registerFixes(annotation2, psiClass2);
    }

    private final void registerFixes(Annotation errorAnnotation, PsiClass psiClass2) {
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        errorAnnotation.registerFix((IntentionAction)quickFixFactory.createImplementMethodsFix(psiClass2));
        if (!(psiClass2 instanceof PsiAnonymousClass)) {
            PsiModifierList psiModifierList = psiClass2.getModifierList();
            if (!(psiModifierList != null ? psiModifierList.hasExplicitModifier("final") : false)) {
                errorAnnotation.registerFix((IntentionAction)quickFixFactory.createModifierListFix((PsiModifierListOwner)psiClass2, "abstract", true, false));
            }
        }
    }
}

