/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull KtFile file2) {
        KtFile contextFile;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        TargetPlatform explicitPlatform = KtPsiFactoryKt.getTargetPlatform(file2);
        if (explicitPlatform != null) {
            TargetPlatform targetPlatform = explicitPlatform;
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        if (file2 instanceof KtCodeFragment && (contextFile = ((KtCodeFragment)file2).getContextContainingFile()) != null) {
            TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(contextFile);
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        PsiElement context = KtPsiFactoryKt.getAnalysisContext(file2);
        if (context != null) {
            PsiFile contextFile2 = context.getContainingFile();
            TargetPlatform targetPlatform = contextFile2 instanceof KtFile ? TargetPlatformDetector.getPlatform((KtFile)contextFile2) : JvmPlatform.INSTANCE;
            if (targetPlatform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
            }
            return targetPlatform;
        }
        TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform((PsiFile)file2);
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        return targetPlatform;
    }

    public static TargetPlatform getPlatform(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        VirtualFile virtualFile2 = file2.getOriginalFile().getVirtualFile();
        if (virtualFile2 == null) {
            return TargetPlatformDetector.getDefaultPlatform(file2);
        }
        Module moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getModuleForFile(virtualFile2);
        if (moduleForFile == null) {
            return TargetPlatformDetector.getDefaultPlatform(file2);
        }
        return TargetPlatformDetector.getPlatform(moduleForFile);
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        TargetPlatform targetPlatform = ProjectStructureUtil.getCachedPlatformForModule(module);
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getPlatform"));
        }
        return targetPlatform;
    }

    @NotNull
    private static TargetPlatform getDefaultPlatform(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getDefaultPlatform"));
        }
        LOG.info("Using default platform for file: " + file2.getName());
        JvmPlatform jvmPlatform = JvmPlatform.INSTANCE;
        if (jvmPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/TargetPlatformDetector", "getDefaultPlatform"));
        }
        return jvmPlatform;
    }
}

