/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionLiteralReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000b\u001d\u001e\u001f !\"#$%&'B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\r\u0010\u0010\u001a\u00070\r\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "changeFunctionLiteralReturnTypeFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix;", "isUnitType", "", "typeContainsError", "typePresentation", "", "typeSourceCode", "functionPresentation", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "ChangingReturnTypeToNothingFactory", "ChangingReturnTypeToUnitFactory", "Companion", "CompareToTypeMismatchFactory", "ComponentFunctionReturnTypeMismatchFactory", "ForCalled", "ForEnclosing", "ForOverridden", "HasNextFunctionTypeMismatchFactory", "OnType", "ReturnTypeMismatchOnOverrideFactory", "idea"})
public abstract class ChangeCallableReturnTypeFix
extends KotlinQuickFixAction<KtCallableDeclaration> {
    private final ChangeFunctionLiteralReturnTypeFix changeFunctionLiteralReturnTypeFix;
    private final boolean typeContainsError;
    private final String typePresentation;
    private final String typeSourceCode;
    private final boolean isUnitType;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String functionPresentation() {
        KtCallableDeclaration element2;
        String name2;
        Object t = this.getElement();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        if ((name2 = (element2 = (KtCallableDeclaration)t).getName()) != null) {
            String fullName;
            Object object;
            Object it;
            ClassDescriptor container2;
            Object object2;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(element2, null, 1, null).getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            String containerName2 = (object2 = (container2 = (ClassDescriptor)declarationDescriptor)) != null && (object2 = object2.getName()) != null && (object2 = !((Name)(it = (object = object2))).isSpecial() ? object : null) != null ? ((Name)object2).asString() : null;
            String string = fullName = containerName2 != null ? "'" + containerName2 + "." + name2 + "'" : "'" + name2 + "'";
            if (element2 instanceof KtParameter) {
                return "property " + fullName;
            }
            return "function " + fullName;
        }
        return null;
    }

    @NotNull
    public String getText() {
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.getElement();
        if (ktCallableDeclaration == null) {
            return "";
        }
        KtCallableDeclaration element2 = ktCallableDeclaration;
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            String string = this.changeFunctionLiteralReturnTypeFix.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"changeFunctionLiteralReturnTypeFix.text");
            return string;
        }
        String functionPresentation = this.functionPresentation();
        if (this.isUnitType && element2 instanceof KtFunction && ((KtFunction)element2).hasBlockBody()) {
            return functionPresentation == null ? "Remove explicitly specified return type" : "Remove explicitly specified return type of " + functionPresentation;
        }
        String typeName = element2 instanceof KtFunction ? "return type" : "type";
        return functionPresentation == null ? "Change " + typeName + " to '" + this.typePresentation + "'" : "Change " + typeName + " of " + functionPresentation + " to '" + this.typePresentation + "'";
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.type.family", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return super.isAvailable(project, editor, file2) && !this.typeContainsError && !(this.getElement() instanceof KtConstructor);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.getElement();
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration element2 = ktCallableDeclaration;
        if (this.changeFunctionLiteralReturnTypeFix != null) {
            Editor editor2 = editor;
            if (editor2 == null) {
                Intrinsics.throwNpe();
            }
            this.changeFunctionLiteralReturnTypeFix.invoke(project, editor2, (PsiFile)file2);
        } else if (!(this.isUnitType && element2 instanceof KtFunction && ((KtFunction)element2).hasBlockBody())) {
            KtTypeReference newTypeRef = new KtPsiFactory(project, false, 2, null).createType(this.typeSourceCode);
            KtTypeReference ktTypeReference = element2.setTypeReference(newTypeRef);
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            newTypeRef = ktTypeReference;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, newTypeRef, null, 2, null);
        } else {
            ((KtFunction)element2).setTypeReference(null);
        }
    }

    public ChangeCallableReturnTypeFix(@NotNull KtCallableDeclaration element2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        this.typeContainsError = ErrorUtils.containsErrorType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
        this.isUnitType = TypeUtilsKt.isUnit(type2);
        if (element2 instanceof KtFunctionLiteral) {
            KtLambdaExpression functionLiteralExpression;
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtLambdaExpression.class);
            if (ktLambdaExpression == null) {
                String string = "FunctionLiteral outside any FunctionLiteralExpression: " + PsiUtilsKt.getElementTextWithContext(element2);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtLambdaExpression ktLambdaExpression2 = functionLiteralExpression = ktLambdaExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktLambdaExpression2, (String)"functionLiteralExpression");
            this.changeFunctionLiteralReturnTypeFix = new ChangeFunctionLiteralReturnTypeFix(ktLambdaExpression2, type2);
        } else {
            this.changeFunctionLiteralReturnTypeFix = null;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$OnType;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class OnType
    extends ChangeCallableReturnTypeFix
    implements HighPriorityAction {
        @Nullable
        public Void functionPresentation() {
            return null;
        }

        public OnType(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ForEnclosing;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForEnclosing
    extends ChangeCallableReturnTypeFix
    implements HighPriorityAction {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return "enclosing function";
            }
            String presentation = string;
            return "enclosing " + presentation;
        }

        public ForEnclosing(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ForCalled;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForCalled
    extends ChangeCallableReturnTypeFix {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return "called function";
            }
            String presentation = string;
            return this.getElement() instanceof KtParameter ? "accessed " + presentation : "called " + presentation;
        }

        public ForCalled(@NotNull KtCallableDeclaration element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ForOverridden;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/types/KotlinType;)V", "functionPresentation", "", "idea"})
    public static final class ForOverridden
    extends ChangeCallableReturnTypeFix {
        @Override
        @Nullable
        public String functionPresentation() {
            String string = super.functionPresentation();
            if (string == null) {
                return null;
            }
            String presentation = string;
            return "base " + presentation;
        }

        public ForOverridden(@NotNull KtFunction element2, @NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(element2, type2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ComponentFunctionReturnTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ComponentFunctionReturnTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ComponentFunctionReturnTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KotlinType expectedType;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtDestructuringDeclarationEntry entry = Companion.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
            BindingContext context = ResolutionUtils.analyze(entry, BodyResolveMode.PARTIAL);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            Object d = resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.candidateDescriptor");
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)d);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration componentFunction = ktCallableDeclaration;
            ReadOnlySlice readOnlySlice = BindingContext.TYPE;
            KtTypeReference ktTypeReference = entry.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType = (KotlinType)context.get(readOnlySlice, ktTypeReference);
            if (kotlinType == null) {
                return null;
            }
            KotlinType kotlinType2 = expectedType = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expectedType");
            return new ForCalled(componentFunction, kotlinType2);
        }

        private ComponentFunctionReturnTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new ComponentFunctionReturnTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$HasNextFunctionTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class HasNextFunctionTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final HasNextFunctionTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            FunctionDescriptor hasNextDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtExpression ktExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtExpression.class);
            if (ktExpression == null) {
                String string = "HAS_NEXT_FUNCTION_TYPE_MISMATCH reported on element that is not within any expression";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtExpression expression2 = ktExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            ResolvedCall resolvedCall2 = (ResolvedCall)context.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            FunctionDescriptor functionDescriptor2 = hasNextDescriptor = (FunctionDescriptor)resolvedCall3.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"hasNextDescriptor");
            KtFunction ktFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor2);
            if (ktFunction == null) {
                return null;
            }
            KtFunction hasNextFunction = ktFunction;
            KtCallableDeclaration ktCallableDeclaration = hasNextFunction;
            SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(hasNextDescriptor).getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"hasNextDescriptor.builtIns.booleanType");
            return new ForCalled(ktCallableDeclaration, simpleType2);
        }

        private HasNextFunctionTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new HasNextFunctionTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$CompareToTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class CompareToTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final CompareToTypeMismatchFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtBinaryExpression ktBinaryExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtBinaryExpression.class);
            if (ktBinaryExpression == null) {
                String string = "COMPARE_TO_TYPE_MISMATCH reported on element that is not within any expression";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtBinaryExpression expression2 = ktBinaryExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor compareToDescriptor = resolvedCall3.getCandidateDescriptor();
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(compareToDescriptor);
            if (!(psiElement2 instanceof KtFunction)) {
                psiElement2 = null;
            }
            KtFunction ktFunction = (KtFunction)psiElement2;
            if (ktFunction == null) {
                return null;
            }
            KtFunction compareTo = ktFunction;
            KtCallableDeclaration ktCallableDeclaration = compareTo;
            SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(compareToDescriptor).getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"compareToDescriptor.builtIns.intType");
            return new ForCalled(ktCallableDeclaration, simpleType2);
        }

        private CompareToTypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new CompareToTypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ReturnTypeMismatchOnOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ReturnTypeMismatchOnOverrideFactory
    extends KotlinIntentionActionsFactory {
        public static final ReturnTypeMismatchOnOverrideFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return CollectionsKt.emptyList();
            }
            KtFunction function2 = ktFunction;
            LinkedList<ChangeCallableReturnTypeFix> actions2 = new LinkedList<ChangeCallableReturnTypeFix>();
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny(function2, BodyResolveMode.FULL);
            if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                declarationDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
            if (functionDescriptor2 == null) {
                return CollectionsKt.emptyList();
            }
            FunctionDescriptor descriptor2 = functionDescriptor2;
            KotlinType matchingReturnType = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(descriptor2);
            if (matchingReturnType != null) {
                KtFunction ktFunction2 = function2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
                actions2.add(new OnType(ktFunction2, matchingReturnType));
            }
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                return actions2;
            }
            KotlinType functionType2 = kotlinType;
            LinkedList<FunctionDescriptor> overriddenMismatchingFunctions = new LinkedList<FunctionDescriptor>();
            for (FunctionDescriptor functionDescriptor3 : descriptor2.getOverriddenDescriptors()) {
                KotlinType overriddenFunctionType;
                if (functionDescriptor3.getReturnType() == null) {
                    continue;
                }
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType2, overriddenFunctionType)) continue;
                overriddenMismatchingFunctions.add(functionDescriptor3);
            }
            if (overriddenMismatchingFunctions.size() == 1) {
                Object e = overriddenMismatchingFunctions.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"overriddenMismatchingFunctions[0]");
                PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)e);
                if (psiElement2 instanceof KtFunction) {
                    KtFunction ktFunction3 = (KtFunction)psiElement2;
                    KotlinType kotlinType2 = functionType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"functionType");
                    actions2.add(new ForOverridden(ktFunction3, kotlinType2));
                }
            }
            return actions2;
        }

        private ReturnTypeMismatchOnOverrideFactory() {
            INSTANCE = this;
        }

        static {
            new ReturnTypeMismatchOnOverrideFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ChangingReturnTypeToUnitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ChangingReturnTypeToUnitFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ChangingReturnTypeToUnitFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtFunction function2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return null;
            }
            KtFunction ktFunction2 = function2 = ktFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
            SimpleType simpleType2 = PlatformKt.getBuiltIns(function2).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"function.builtIns.unitType");
            return new ForEnclosing(ktFunction2, (KotlinType)simpleType2);
        }

        private ChangingReturnTypeToUnitFactory() {
            INSTANCE = this;
        }

        static {
            new ChangingReturnTypeToUnitFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$ChangingReturnTypeToNothingFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class ChangingReturnTypeToNothingFactory
    extends KotlinSingleIntentionActionFactory {
        public static final ChangingReturnTypeToNothingFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtFunction function2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtFunction ktFunction = QuickFixUtil.getParentElementOfType(diagnostic, KtFunction.class);
            if (ktFunction == null) {
                return null;
            }
            KtFunction ktFunction2 = function2 = ktFunction;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction2, (String)"function");
            SimpleType simpleType2 = PlatformKt.getBuiltIns(function2).getNothingType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"function.builtIns.nothingType");
            return new ForEnclosing(ktFunction2, (KotlinType)simpleType2);
        }

        private ChangingReturnTypeToNothingFactory() {
            INSTANCE = this;
        }

        static {
            new ChangingReturnTypeToNothingFactory();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCallableReturnTypeFix$Companion;", "", "()V", "getDestructuringDeclarationEntryThatTypeMismatchComponentFunction", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion {
        @NotNull
        public final KtDestructuringDeclarationEntry getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Name componentName = (Name)((DiagnosticWithParameters3)Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.cast(diagnostic)).getA();
            String string = componentName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentName.asString()");
            int componentIndex = DataClassDescriptorResolver.INSTANCE.getComponentIndex(string);
            KtDestructuringDeclaration ktDestructuringDeclaration = QuickFixUtil.getParentElementOfType(diagnostic, KtDestructuringDeclaration.class);
            if (ktDestructuringDeclaration == null) {
                String string2 = "COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH reported on expression that is not within any multi declaration";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            KtDestructuringDeclaration multiDeclaration = ktDestructuringDeclaration;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = multiDeclaration.getEntries().get(componentIndex - 1);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"multiDeclaration.entries[componentIndex - 1]");
            return ktDestructuringDeclarationEntry;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

