/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertExtensionToFunctionTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/types/KotlinType;)V", "targetTypeStringLong", "", "targetTypeStringShort", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "renderType", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "Factory", "idea"})
public final class ConvertExtensionToFunctionTypeFix
extends KotlinQuickFixAction<KtTypeReference> {
    private final String targetTypeStringShort;
    private final String targetTypeStringLong;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return "Convert supertype to '" + this.targetTypeStringShort + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Convert extension function type to regular function type";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        PsiElement psiElement2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtTypeReference ktTypeReference = (KtTypeReference)this.getElement();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference element2 = ktTypeReference;
        PsiElement psiElement3 = element2;
        PsiElement newElement$iv = new KtPsiFactory(project, false, 2, null).createType(this.targetTypeStringLong);
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtTypeReference) {
            psiElement2 = result$iv;
        } else {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            psiElement2 = (KtTypeReference)((Object)ktExpression);
        }
        KtTypeReference replaced = (KtTypeReference)psiElement2;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, replaced, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderType(@NotNull KotlinType $receiver, DescriptorRenderer renderer2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        StringBuilder stringBuilder;
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        $receiver2.append('(');
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.dropLast($receiver.getArguments(), (int)1);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
            String string = renderer2.renderType(kotlinType);
            collection.add(string);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)$receiver2, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
        $receiver2.append(") -> ");
        $receiver2.append(renderer2.renderType(FunctionTypesKt.getReturnTypeFromFunctionType($receiver)));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public ConvertExtensionToFunctionTypeFix(@NotNull KtTypeReference element2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        this.targetTypeStringShort = this.renderType(type2, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES);
        this.targetTypeStringLong = this.renderType(type2, IdeDescriptorRenderers.SOURCE_CODE);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertExtensionToFunctionTypeFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinIntentionActionsFactory {
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            SimpleDiagnostic casted = (SimpleDiagnostic)Errors.SUPERTYPE_IS_EXTENSION_FUNCTION_TYPE.cast(diagnostic);
            KtTypeReference element2 = (KtTypeReference)casted.getPsiElement();
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, element2);
            if (kotlinType == null) {
                return CollectionsKt.emptyList();
            }
            KotlinType type2 = kotlinType;
            if (!FunctionTypesKt.isExtensionFunctionType(type2)) {
                return CollectionsKt.emptyList();
            }
            KtTypeReference ktTypeReference = element2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"element");
            KotlinType kotlinType2 = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
            return CollectionsKt.listOf((Object)new ConvertExtensionToFunctionTypeFix(ktTypeReference, kotlinType2));
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

