/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddArrayOfTypeFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddToStringFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeToUseSpreadOperatorFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.LetImplementInterfaceFix;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFix;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Companion", "idea"})
public final class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        PsiElement it;
        KotlinType expressionType;
        KotlinType expectedType;
        PsiElement diagnosticElement;
        BindingContext context;
        LinkedList<KotlinQuickFixAction> actions2;
        block44: {
            block46: {
                block45: {
                    KtAnnotationEntry annotationEntry2;
                    KtFunction declaration2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    PsiElement expressionParent;
                    KtCallableDeclaration function2;
                    KotlinType typeToInsert;
                    LexicalScope scope2;
                    KtProperty property2;
                    KotlinType nullableExpected;
                    Object diagnosticWithParameters;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    actions2 = new LinkedList<KotlinQuickFixAction>();
                    PsiFile psiFile = diagnostic.getPsiFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    context = ResolutionUtils.analyzeFully((KtFile)psiFile);
                    diagnosticElement = diagnostic.getPsiElement();
                    if (!(diagnosticElement instanceof KtExpression)) {
                        QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("Unexpected element: " + diagnosticElement.getText());
                        return CollectionsKt.emptyList();
                    }
                    DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                    if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
                        Object a = ((DiagnosticWithParameters2)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE)) {
                        diagnosticWithParameters = (DiagnosticWithParameters1)Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
                        Object a = ((DiagnosticWithParameters1)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = TypeUtilsKt.makeNullable(expectedType);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Object a = ((DiagnosticWithParameters2)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Object b = ((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                        Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                        expectedType = (KotlinType)b;
                        expressionType = context.getType((KtExpression)diagnosticElement);
                        if (expressionType == null) {
                            QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("No type inferred: " + ((KtExpression)diagnosticElement).getText());
                            return CollectionsKt.emptyList();
                        }
                    } else {
                        QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                        return CollectionsKt.emptyList();
                    }
                    if (TypeUtilsKt.isPrimitiveNumberType(expressionType) && TypeUtilsKt.isPrimitiveNumberType(expectedType)) {
                        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = null;
                        if (diagnosticElement instanceof KtConstantExpression && !KotlinBuiltIns.isChar(expectedType)) {
                            PsiElement psiElement2 = diagnosticElement;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnosticElement");
                            wrongPrimitiveLiteralFix = new WrongPrimitiveLiteralFix((KtConstantExpression)psiElement2, expectedType);
                            actions2.add(wrongPrimitiveLiteralFix);
                        }
                        PsiElement psiElement3 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"diagnosticElement");
                        actions2.add(new NumberConversionFix((KtExpression)psiElement3, expectedType, wrongPrimitiveLiteralFix));
                    }
                    if (KotlinBuiltIns.isCharSequenceOrNullableCharSequence(expectedType) || KotlinBuiltIns.isStringOrNullableString(expectedType)) {
                        PsiElement psiElement4 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"diagnosticElement");
                        actions2.add(new AddToStringFix((KtExpression)psiElement4, false));
                        if (expectedType.isMarkedNullable() && expressionType.isMarkedNullable()) {
                            PsiElement psiElement5 = diagnosticElement;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"diagnosticElement");
                            actions2.add(new AddToStringFix((KtExpression)psiElement5, true));
                        }
                    }
                    if (TypeUtilsKt.isInterface(expectedType)) {
                        KtClassOrObject expressionTypeDeclaration;
                        PsiElement psiElement6;
                        PsiElement psiElement7;
                        Object it2;
                        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor != null) {
                            Object object = it2 = (diagnosticWithParameters = classifierDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                            psiElement7 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)object);
                        } else {
                            psiElement7 = psiElement6 = null;
                        }
                        if (!(psiElement7 instanceof KtClassOrObject)) {
                            psiElement6 = null;
                        }
                        KtClassOrObject ktClassOrObject = expressionTypeDeclaration = (KtClassOrObject)psiElement6;
                        if (ktClassOrObject != null) {
                            it2 = diagnosticWithParameters = ktClassOrObject;
                            actions2.add(new LetImplementInterfaceFix((KtClassOrObject)it2, expectedType, expressionType));
                        }
                    }
                    if (!(diagnosticElement instanceof KtBinaryExpressionWithTypeRHS) && !(((KtExpression)diagnosticElement).getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
                        PsiElement psiElement8 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement8, (String)"diagnosticElement");
                        actions2.add(new CastExpressionFix((KtExpression)psiElement8, expectedType));
                    }
                    if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, nullableExpected = TypeUtilsKt.makeNullable(expectedType))) {
                        PsiElement psiElement9 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement9, (String)"diagnosticElement");
                        actions2.add(new AddExclExclCallFix(psiElement9));
                    }
                    if ((property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtProperty.class)) != null) {
                        KtPropertyAccessor getter = property2.getGetter();
                        KtExpression initializer2 = property2.getInitializer();
                        if (QuickFixUtil.canEvaluateTo(initializer2, (KtExpression)diagnosticElement) || getter != null && QuickFixUtil.canFunctionOrGetterReturnExpression(getter, (KtExpression)diagnosticElement)) {
                            scope2 = ScopeUtils.getResolutionScope(property2, context, ResolutionUtils.getResolutionFacade(property2));
                            typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                            actions2.add(new ChangeVariableTypeFix(property2, typeToInsert));
                        }
                    }
                    KtCallableDeclaration ktCallableDeclaration = function2 = (expressionParent = ((KtExpression)diagnosticElement).getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expressionParent, context) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtFunction.class, (boolean)true);
                    if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, (KtExpression)diagnosticElement)) {
                        scope2 = ScopeUtils.getResolutionScope(function2, context, ResolutionUtils.getResolutionFacade(function2));
                        typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                        actions2.add(new ChangeCallableReturnTypeFix.ForEnclosing((KtFunction)function2, typeToInsert));
                    }
                    if (diagnosticElement instanceof KtOperationExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions2.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if (diagnosticElement instanceof KtCallExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions2.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if ((annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtAnnotationEntry.class)) == null) break block44;
                    if (!KotlinBuiltIns.isArray(expectedType)) break block45;
                    KotlinType kotlinType = expectedType.getArguments().get(0).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expectedType.arguments[0].type");
                    if (TypeUtilsKt.isSubtypeOf(expressionType, kotlinType)) break block46;
                }
                if (!KotlinBuiltIns.isPrimitiveArray(expectedType)) break block44;
            }
            PsiElement psiElement10 = diagnosticElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement10, (String)"diagnosticElement");
            actions2.add(new AddArrayOfTypeFix((KtExpression)psiElement10, expectedType));
        }
        PsiElement $receiver$iv = diagnosticElement;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtParameter.class, (boolean)true);
        if (ktParameter != null && Intrinsics.areEqual((Object)(it = ($receiver$iv = ktParameter)).getDefaultValue(), (Object)diagnosticElement)) {
            actions2.add(new ChangeParameterTypeFix((KtParameter)it, expressionType));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getParentResolvedCall((KtElement)diagnosticElement, context, true);
        if (resolvedCall3 != null) {
            KtExpression ktExpression;
            KtIfExpression parentIf;
            KtIfExpression ktIfExpression = parentIf = QuickFixUtil.getParentIfForBranch((KtExpression)diagnosticElement);
            if (ktIfExpression != null) {
                ktExpression = ktIfExpression;
            } else {
                PsiElement psiElement11 = diagnosticElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement11, (String)"diagnosticElement");
                ktExpression = (KtExpression)psiElement11;
            }
            KtExpression argumentExpression = ktExpression;
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall3.getCall(), argumentExpression);
            if (valueArgument != null) {
                KotlinType valueArgumentType;
                Object object;
                KotlinType kotlinType;
                ValueParameterDescriptor correspondingParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall3, valueArgument);
                PsiElement psiElement12 = QuickFixUtil.safeGetDeclaration(correspondingParameterDescriptor);
                if (!(psiElement12 instanceof KtParameter)) {
                    psiElement12 = null;
                }
                KtParameter correspondingParameter = (KtParameter)psiElement12;
                KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
                if (diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE) {
                    kotlinType = expressionType;
                } else {
                    KtExpression ktExpression2 = expressionFromArgument;
                    if (ktExpression2 != null) {
                        object = ktExpression2;
                        KtExpression it3 = object;
                        kotlinType = context.getType(it3);
                    } else {
                        kotlinType = valueArgumentType = null;
                    }
                }
                if (valueArgumentType != null) {
                    if (correspondingParameter != null) {
                        KtCallableDeclaration callable2;
                        KtCallableDeclaration ktCallableDeclaration = callable2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
                        LexicalScope scope3 = ktCallableDeclaration != null ? ScopeUtils.getResolutionScope(ktCallableDeclaration, context, ResolutionUtils.getResolutionFacade(callable2)) : null;
                        KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(valueArgumentType, scope3, true);
                        actions2.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert));
                    }
                    if (correspondingParameterDescriptor != null && correspondingParameterDescriptor.getVarargElementType() != null && KotlinBuiltIns.isArray(valueArgumentType) && !(object = (Collection)expressionType.getArguments()).isEmpty() && Intrinsics.areEqual((Object)expressionType.getArguments().get(0).getType().getConstructor(), (Object)expectedType.getConstructor())) {
                        PsiElement psiElement13 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement13, (String)"diagnosticElement");
                        actions2.add(new ChangeToUseSpreadOperatorFix((KtExpression)psiElement13));
                    }
                }
            }
        }
        return actions2;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final KtFunction getFunctionDeclaration(ResolvedCall<?> resolvedCall2) {
            PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall2.getResultingDescriptor());
            if (result2 instanceof KtFunction) {
                return (KtFunction)result2;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

