/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH$J\u0006\u0010 \u001a\u00020\u0017J,\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "callableDescriptor", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getCommandName", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkModifiable", "", "element", "Lcom/intellij/psi/PsiElement;", "forcePerformForSelectedFunctionOnly", "getClosestModifiableDescriptors", "", "performRefactoring", "", "descriptorsForChange", "run", "showSuperFunctionWarningDialog", "", "superCallables", "callableFromEditor", "options", "", "idea"})
public abstract class CallableRefactoring<T extends CallableDescriptor> {
    private final Logger LOG;
    private final CallableMemberDescriptor.Kind kind;
    @NotNull
    private final Project project;
    @NotNull
    private final T callableDescriptor;
    @NotNull
    private final String commandName;

    protected boolean forcePerformForSelectedFunctionOnly() {
        return false;
    }

    private final Collection<CallableDescriptor> getClosestModifiableDescriptors() {
        Collection<CallableMemberDescriptor> collection;
        switch (CallableRefactoring$WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                collection = SetsKt.setOf(this.callableDescriptor);
                break;
            }
            case 2: 
            case 3: {
                T t = this.callableDescriptor;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)t);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected callable kind: " + (Object)((Object)this.kind));
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final int showSuperFunctionWarningDialog(Collection<? extends CallableDescriptor> superCallables, CallableDescriptor callableFromEditor, List<String> options2) {
        void $receiver$iv;
        String string;
        CharSequence it;
        Object object;
        Object item$iv$iv;
        CharSequence $receiver$iv$iv;
        Iterable $receiver$iv2;
        Iterable iterable = $receiver$iv2 = (Iterable)superCallables;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Object object2 = $receiver$iv$iv.iterator();
        while (object2.hasNext()) {
            item$iv$iv = object2.next();
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv$iv;
            object = destination$iv$iv22;
            string = it.getContainingDeclaration().getName().asString();
            object.add(string);
        }
        $receiver$iv2 = null;
        $receiver$iv$iv = null;
        int destination$iv$iv22 = 0;
        object2 = ".\n\n";
        item$iv$iv = ",\n    ";
        it = "\n    ";
        String superString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv22), item$iv$iv, (CharSequence)it, (CharSequence)object2, (int)destination$iv$iv22, $receiver$iv$iv, (Function1)$receiver$iv2, (int)56, null);
        String message2 = KotlinBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT.render(callableFromEditor), callableFromEditor.getContainingDeclaration().getName().asString(), superString, "refactor");
        String string2 = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String title = string2;
        Icon icon = Messages.getQuestionIcon();
        object2 = options2;
        string = title;
        object = message2;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v1;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return Messages.showDialog((String)object, (String)string, (String[])stringArray2, (int)0, (Icon)icon);
    }

    protected final boolean checkModifiable(@NotNull PsiElement element2) {
        String unmodifiableFile;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (KotlinRefactoringUtilKt.canRefactor(element2)) {
            return true;
        }
        PsiFile psiFile = element2.getContainingFile();
        String string = psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getPresentableUrl() : (unmodifiableFile = null);
        if (unmodifiableFile != null) {
            String message2 = RefactoringBundle.message((String)"refactoring.cannot.be.performed") + "\n" + IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{unmodifiableFile});
            String string2 = CommonBundle.getErrorTitle();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Messages.showErrorDialog((Project)this.project, (String)message2, (String)string2);
        } else {
            this.LOG.error("Could not find file for Psi element: " + element2.getText());
        }
        return false;
    }

    protected abstract void performRefactoring(@NotNull Collection<? extends CallableDescriptor> var1);

    public final boolean run() {
        int code;
        CallableMemberDescriptor $i$a$5$assert;
        CallableMemberDescriptor p1;
        Collection<CallableMemberDescriptor> collection;
        boolean bl;
        run.1 buttonPressed$ = run.1.INSTANCE;
        run.2 performForWholeHierarchy$ = run.2.INSTANCE;
        run.3 performForSelectedFunctionOnly$ = run.3.INSTANCE;
        run.4 buildDialogOptions$ = run.4.INSTANCE;
        if (Intrinsics.areEqual((Object)((Object)this.kind), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED))) {
            this.LOG.error("Change signature refactoring should not be called for synthesized member " + this.callableDescriptor);
            return false;
        }
        Collection<CallableDescriptor> closestModifiableDescriptors = this.getClosestModifiableDescriptors();
        if (this.forcePerformForSelectedFunctionOnly()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean bl2 = bl = !closestModifiableDescriptors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Should contain original declaration or some of its super declarations";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((collection = (CallableMemberDescriptor)t) == null || (collection = DescriptorUtilsKt.getDeepestSuperDeclarations(p1 = ($i$a$5$assert = collection))) == null) {
            collection = CollectionsKt.listOf(this.callableDescriptor);
        }
        Collection<CallableMemberDescriptor> deepestSuperDeclarations = collection;
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            this.performRefactoring(deepestSuperDeclarations);
            return true;
        }
        if (closestModifiableDescriptors.size() == 1 && CollectionsKt.subtract((Iterable)deepestSuperDeclarations, (Iterable)closestModifiableDescriptors).isEmpty()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean isSingleFunctionSelected = closestModifiableDescriptors.size() == 1;
        T selectedFunction = isSingleFunctionSelected ? (CallableDescriptor)CollectionsKt.first((Iterable)closestModifiableDescriptors) : this.callableDescriptor;
        List<String> optionsForDialog = buildDialogOptions$.invoke(isSingleFunctionSelected);
        if (performForWholeHierarchy$.invoke(optionsForDialog, code = this.showSuperFunctionWarningDialog((Collection<? extends CallableDescriptor>)deepestSuperDeclarations, (CallableDescriptor)selectedFunction, optionsForDialog))) {
            this.performRefactoring(deepestSuperDeclarations);
        } else if (performForSelectedFunctionOnly$.invoke(optionsForDialog, code)) {
            this.performRefactoring(closestModifiableDescriptors);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final T getCallableDescriptor() {
        return this.callableDescriptor;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    public CallableRefactoring(@NotNull Project project, @NotNull T callableDescriptor, @NotNull String commandName) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
        this.project = project;
        this.callableDescriptor = callableDescriptor;
        this.commandName = commandName;
        this.LOG = Logger.getInstance(CallableRefactoring.class);
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((object = (CallableMemberDescriptor)t) == null || (object = object.getKind()) == null) {
            object = CallableMemberDescriptor.Kind.DECLARATION;
        }
        this.kind = object;
    }
}

