/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractInterfaceHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperclassHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ExtractKotlinFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceParameter.KotlinIntroduceLambdaParameterHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceParameter.KotlinIntroduceParameterHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceProperty.KotlinIntroducePropertyHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinIntroduceVariableHandler;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpHandler;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandler;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.UtilsKt;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringSupportProvider;", "Lcom/intellij/lang/refactoring/RefactoringSupportProvider;", "()V", "getChangeSignatureHandler", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler;", "getExtractFunctionHandler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "getExtractFunctionToScopeHandler", "getExtractInterfaceHandler", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractInterfaceHandler;", "getExtractSuperClassHandler", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperclassHandler;", "getIntroduceFunctionalParameterHandler", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/introduceParameter/KotlinIntroduceLambdaParameterHandler;", "getIntroduceParameterHandler", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/introduceParameter/KotlinIntroduceParameterHandler;", "getIntroducePropertyHandler", "getIntroduceVariableHandler", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler;", "getPullUpHandler", "Lorg/jetbrains/kotlin/idea/refactoring/pullUp/KotlinPullUpHandler;", "getPushDownHandler", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler;", "isInplaceRenameAvailable", "", "element", "Lcom/intellij/psi/PsiElement;", "context", "isMemberInplaceRenameAvailable", "isSafeDeleteAvailable", "idea"})
public final class KotlinRefactoringSupportProvider
extends RefactoringSupportProvider {
    public boolean isSafeDeleteAvailable(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return UtilsKt.canDeleteElement(element2);
    }

    @NotNull
    public KotlinIntroduceVariableHandler getIntroduceVariableHandler() {
        return KotlinIntroduceVariableHandler.INSTANCE;
    }

    @NotNull
    public KotlinIntroduceParameterHandler getIntroduceParameterHandler() {
        return new KotlinIntroduceParameterHandler(null, 1, null);
    }

    @NotNull
    public KotlinIntroduceLambdaParameterHandler getIntroduceFunctionalParameterHandler() {
        return new KotlinIntroduceLambdaParameterHandler(null, 1, null);
    }

    @NotNull
    public final RefactoringActionHandler getIntroducePropertyHandler() {
        return new KotlinIntroducePropertyHandler(null, 1, null);
    }

    @NotNull
    public final RefactoringActionHandler getExtractFunctionHandler() {
        return new ExtractKotlinFunctionHandler(false, null, 3, null);
    }

    @NotNull
    public final RefactoringActionHandler getExtractFunctionToScopeHandler() {
        return new ExtractKotlinFunctionHandler(true, ExtractKotlinFunctionHandler.InteractiveExtractionHelper.INSTANCE);
    }

    public boolean isInplaceRenameAvailable(@NotNull PsiElement element2, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement2 = element2;
        if (psiElement2 instanceof KtTypeParameter) {
            return true;
        }
        if (psiElement2 instanceof KtProperty) {
            if (((KtProperty)element2).isLocal()) {
                return true;
            }
        } else {
            if (psiElement2 instanceof KtDestructuringDeclarationEntry) {
                return true;
            }
            if (psiElement2 instanceof KtFunction) {
                if (((KtFunction)element2).isLocal() && ((KtFunction)element2).getNameIdentifier() != null) {
                    return true;
                }
            } else if (psiElement2 instanceof KtParameter) {
                PsiElement parent2 = ((KtParameter)element2).getParent();
                if (parent2 instanceof KtForExpression) {
                    return true;
                }
                if (parent2 instanceof KtParameterList) {
                    PsiElement grandparent = ((KtParameterList)parent2).getParent();
                    return grandparent instanceof KtCatchClause || grandparent instanceof KtFunctionLiteral;
                }
            }
        }
        return false;
    }

    public boolean isMemberInplaceRenameAvailable(@NotNull PsiElement element2, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtNamedDeclaration;
    }

    @NotNull
    public KotlinChangeSignatureHandler getChangeSignatureHandler() {
        return new KotlinChangeSignatureHandler();
    }

    @NotNull
    public KotlinPullUpHandler getPullUpHandler() {
        return new KotlinPullUpHandler();
    }

    @NotNull
    public KotlinPushDownHandler getPushDownHandler() {
        return new KotlinPushDownHandler();
    }

    @NotNull
    public KotlinExtractSuperclassHandler getExtractSuperClassHandler() {
        return KotlinExtractSuperclassHandler.INSTANCE;
    }

    @NotNull
    public KotlinExtractInterfaceHandler getExtractInterfaceHandler() {
        return KotlinExtractInterfaceHandler.INSTANCE;
    }
}

