/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticVariableRenamerKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00050\u0005H\u0016J\u0010\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00050\u0005H\u0016J\u0010\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00050\u0005H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "klass", "Lcom/intellij/psi/PsiNamedElement;", "newClassName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/util/Collection;)V", "toUnpluralize", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "canonicalNameToName", "canonicalName", "element", "entityName", "kotlin.jvm.PlatformType", "getDialogDescription", "getDialogTitle", "nameToCanonicalName", "name", "Companion", "idea"})
public final class AutomaticVariableRenamer
extends AutomaticRenamer {
    private final ArrayList<KtNamedDeclaration> toUnpluralize;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.variables.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.variables.with.the.following.names.to");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.variable");
    }

    @Nullable
    protected String nameToCanonicalName(@NotNull String name2, @NotNull PsiNamedElement element2) {
        String propertyName;
        String string;
        Object v0;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!(element2 instanceof KtNamedDeclaration)) {
                return name2;
            }
            Iterable $receiver$iv = LightClassUtilsKt.toLightElements((KtElement)element2);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PsiVariable psiVariable = v0;
        if (psiVariable != null) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
            string = codeStyleManager.variableNameToPropertyName(name2, codeStyleManager.getVariableKind(psiVariable));
        } else {
            string = propertyName = name2;
        }
        if (this.toUnpluralize.contains(element2)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.toUnpluralize.remove(element2);
        }
        return propertyName;
    }

    @Nullable
    protected String canonicalNameToName(@NotNull String canonicalName, @NotNull PsiNamedElement element2) {
        String string;
        Object v0;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!(element2 instanceof KtNamedDeclaration)) {
                return canonicalName;
            }
            Iterable $receiver$iv = LightClassUtilsKt.toLightElements((KtElement)element2);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof PsiVariable)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        PsiVariable psiVariable = v0;
        if (psiVariable != null) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
            string = codeStyleManager.propertyNameToVariableName(canonicalName, codeStyleManager.getVariableKind(psiVariable));
        } else {
            string = canonicalName;
        }
        String varName = string;
        return this.toUnpluralize.contains(element2) ? StringUtil.pluralize((String)varName) : varName;
    }

    public AutomaticVariableRenamer(@NotNull PsiNamedElement klass2, @NotNull String newClassName, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)newClassName, (String)"newClassName");
        Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
        this.toUnpluralize = new ArrayList();
        for (UsageInfo usageInfo : usages2) {
            DeclarationDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor;
            Boolean bl;
            KtCallableDeclaration parameterOrVariable;
            PsiElement usageElement;
            if (usageInfo.getElement() == null) {
                continue;
            }
            if ((KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{KtVariableDeclaration.class, KtParameter.class}) == null) {
                continue;
            }
            KtTypeReference ktTypeReference = parameterOrVariable.getTypeReference();
            if (ktTypeReference != null) {
                PsiElement psiElement2 = ktTypeReference;
                PsiElement psiElement3 = usageElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"usageElement");
                bl = PsiUtilsKt.isAncestor$default(psiElement2, psiElement3, false, 2, null);
            } else {
                bl = null;
            }
            if (Intrinsics.areEqual(bl, (Object)true) ^ true) continue;
            try {
                declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(parameterOrVariable, null, 1, null);
            }
            catch (NoDescriptorForDeclarationException e) {
                Companion.getLOG().error((Throwable)e);
                continue;
            }
            DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            KotlinType type2 = ((VariableDescriptor)declarationDescriptor2).getType();
            if (AutomaticVariableRenamerKt.access$isCollectionLikeOf(type2, klass2)) {
                this.toUnpluralize.add(parameterOrVariable);
            }
            this.myElements.add(parameterOrVariable);
        }
        String string = klass2.getName();
        this.suggestAllNames(string != null ? UtilsKt.unquote(string) : null, UtilsKt.unquote(newClassName));
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(AutomaticVariableRenamer.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticVariableRenamer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

