/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiClass;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;

public class JetRunConfigurationEditor
extends SettingsEditor<JetRunConfiguration>
implements PanelWithAnchor {
    private JPanel mainPanel;
    private LabeledComponent<JTextField> mainClass;
    private CommonJavaParametersPanel commonProgramParameters;
    private LabeledComponent<ModulesComboBox> moduleChooser;
    private JrePathEditor jrePathEditor;
    private final ConfigurationModuleSelector moduleSelector;
    private JComponent anchor;

    public JetRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.moduleSelector = new ConfigurationModuleSelector(project, (ModulesComboBox)this.moduleChooser.getComponent());
        this.jrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies((ModulesComboBox)((ModulesComboBox)this.moduleChooser.getComponent()), (boolean)false));
        this.commonProgramParameters.setModuleContext(this.moduleSelector.getModule());
        ((ModulesComboBox)this.moduleChooser.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JetRunConfigurationEditor.this.commonProgramParameters.setModuleContext(JetRunConfigurationEditor.this.moduleSelector.getModule());
            }
        });
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.mainClass, this.commonProgramParameters, this.jrePathEditor, this.jrePathEditor, this.moduleChooser});
    }

    protected void applyEditorTo(JetRunConfiguration configuration2) throws ConfigurationException {
        this.commonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.applyTo((ModuleBasedConfiguration)configuration2);
        String className2 = ((JTextField)this.mainClass.getComponent()).getText();
        PsiClass aClass2 = this.moduleSelector.findClass(className2);
        configuration2.setRunClass(aClass2 != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass2) : className2);
        configuration2.setAlternativeJrePath(this.jrePathEditor.getJrePathOrName());
        configuration2.setAlternativeJrePathEnabled(this.jrePathEditor.isAlternativeJreSelected());
    }

    protected void resetEditorFrom(JetRunConfiguration configuration2) {
        this.commonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.reset((ModuleBasedConfiguration)configuration2);
        ((JTextField)this.mainClass.getComponent()).setText(configuration2.MAIN_CLASS_NAME != null ? configuration2.MAIN_CLASS_NAME.replaceAll("\\$", "\\.") : "");
        this.jrePathEditor.setPathOrName(configuration2.ALTERNATIVE_JRE_PATH, configuration2.ALTERNATIVE_JRE_PATH_ENABLED);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.mainClass = new LabeledComponent();
        JTextField myMainClassField = new JTextField();
        this.mainClass.setComponent((JComponent)myMainClassField);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor2) {
        this.anchor = anchor2;
        this.mainClass.setAnchor(anchor2);
        this.commonProgramParameters.setAnchor(anchor2);
        this.jrePathEditor.setAnchor(anchor2);
        this.moduleChooser.setAnchor(anchor2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<JTextField> labeledComponent2 = this.mainClass;
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.main.class.label"));
        labeledComponent2.setLabelLocation("West");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.commonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.moduleChooser = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setLabelLocation("West");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.jrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

