/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001c\u0010\u000f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003\u00a8\u0006\u0012"}, d2={"findMethodCalls", "", "Lcom/intellij/psi/PsiMethodCallExpression;", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "method", "Lcom/intellij/psi/PsiMethod;", "scope", "Lcom/intellij/psi/PsiElement;", "findVariableUsages", "Lcom/intellij/psi/PsiReferenceExpression;", "variable", "Lcom/intellij/psi/PsiVariable;", "hasWriteAccesses", "", "searcher", "isInVariableInitializer", "isVar", "Lcom/intellij/psi/PsiField;", "j2k"})
public final class ReferenceSearcherKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PsiReferenceExpression> findVariableUsages(@NotNull ReferenceSearcher $receiver, @NotNull PsiVariable variable2, @NotNull PsiElement scope2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Iterable iterable = $receiver$iv = (Iterable)$receiver.findLocalUsages((PsiElement)variable2, scope2);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiReferenceExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PsiMethodCallExpression> findMethodCalls(@NotNull ReferenceSearcher $receiver, @NotNull PsiMethod method, @NotNull PsiElement scope2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Iterable iterable = $receiver$iv = (Iterable)$receiver.findLocalUsages((PsiElement)method, scope2);
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PsiMethodCallExpression psiMethodCallExpression;
            Object object;
            Object element$iv$iv = element$iv$iv$iv;
            PsiReference it = (PsiReference)element$iv$iv;
            if (it instanceof PsiReferenceExpression) {
                PsiMethodCallExpression methodCall;
                PsiElement psiElement2 = ((PsiReferenceExpression)it).getParent();
                if (!(psiElement2 instanceof PsiMethodCallExpression)) {
                    psiElement2 = null;
                }
                PsiMethodCallExpression psiMethodCallExpression2 = methodCall = (PsiMethodCallExpression)psiElement2;
                object = Intrinsics.areEqual((Object)(psiMethodCallExpression2 != null ? psiMethodCallExpression2.getMethodExpression() : null), (Object)it) ? methodCall : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            PsiMethodCallExpression it$iv$iv = psiMethodCallExpression = object;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isVar(@NotNull PsiField $receiver, @NotNull ReferenceSearcher searcher) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        if ($receiver.hasModifierProperty("final")) {
            return false;
        }
        if (!$receiver.hasModifierProperty("private")) {
            return true;
        }
        PsiClass psiClass2 = $receiver.getContainingClass();
        if (psiClass2 == null) return true;
        PsiClass containingClass = psiClass2;
        PsiVariable psiVariable = (PsiVariable)$receiver;
        PsiClass psiClass3 = containingClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass3, (String)"containingClass");
        Iterable iterable = $receiver$iv = (Iterable)ReferenceSearcherKt.findVariableUsages(searcher, psiVariable, (PsiElement)psiClass3);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiReferenceExpression it = (PsiReferenceExpression)element$iv$iv;
            if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List writes = (List)destination$iv$iv;
        if (writes.size() == 0) {
            return false;
        }
        if (writes.size() > 1) {
            return true;
        }
        PsiReferenceExpression write = (PsiReferenceExpression)CollectionsKt.single((List)writes);
        PsiElement parent2 = write.getParent();
        if (!(parent2 instanceof PsiAssignmentExpression)) return true;
        if (!Intrinsics.areEqual((Object)((PsiAssignmentExpression)parent2).getOperationSign().getTokenType(), (Object)JavaTokenType.EQ)) return true;
        if (!UtilsKt.isQualifierEmptyOrThis(write)) return true;
        PsiMethod constructor2 = UtilsKt.getContainingConstructor((PsiElement)write);
        if (constructor2 == null) return true;
        if (Intrinsics.areEqual((Object)constructor2.getContainingClass(), (Object)containingClass) ^ true) return true;
        if (!(((PsiAssignmentExpression)parent2).getParent() instanceof PsiExpressionStatement)) return true;
        PsiElement psiElement2 = ((PsiAssignmentExpression)parent2).getParent();
        if (!(Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getParent() : null), (Object)constructor2.getBody()) ^ true)) return false;
        return true;
    }

    public static final boolean hasWriteAccesses(@NotNull PsiVariable $receiver, @NotNull ReferenceSearcher searcher, @Nullable PsiElement scope2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
            if (scope2 != null) {
                Iterable $receiver$iv = ReferenceSearcherKt.findVariableUsages(searcher, $receiver, scope2);
                for (Object element$iv : $receiver$iv) {
                    PsiReferenceExpression it = (PsiReferenceExpression)element$iv;
                    if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInVariableInitializer(@NotNull PsiVariable $receiver, @NotNull ReferenceSearcher searcher, @Nullable PsiElement scope2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
            if (scope2 != null) {
                Iterable $receiver$iv = ReferenceSearcherKt.findVariableUsages(searcher, $receiver, scope2);
                for (Object element$iv : $receiver$iv) {
                    PsiReferenceExpression it = (PsiReferenceExpression)element$iv;
                    PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)((PsiElement)it), (Class[])new Class[]{PsiParenthesizedExpression.class});
                    if (!(parent2 instanceof PsiVariable && Intrinsics.areEqual((Object)((PsiVariable)parent2).getInitializer(), (Object)it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

