/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamWithReceiverResolver;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.storage.CacheWithNullableValues;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\tH\u0016J!\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012H\u0017\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/java/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/load/java/components/SamConversionResolver;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "samWithReceiverResolver", "Lorg/jetbrains/kotlin/load/java/sam/SamWithReceiverResolver;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/load/java/sam/SamWithReceiverResolver;)V", "functionTypesForSamInterfaces", "Lorg/jetbrains/kotlin/storage/CacheWithNullableValues;", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "Lorg/jetbrains/kotlin/types/SimpleType;", "getSamWithReceiverResolver", "()Lorg/jetbrains/kotlin/load/java/sam/SamWithReceiverResolver;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "resolveFunctionTypeIfSamInterface", "classDescriptor", "resolveSamAdapter", "D", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "original", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamConstructor", "Lorg/jetbrains/kotlin/load/java/descriptors/SamConstructorDescriptor;", "constructorOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "classifier", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "frontend.java"})
public final class SamConversionResolverImpl
implements SamConversionResolver {
    private final CacheWithNullableValues<JavaClassDescriptor, SimpleType> functionTypesForSamInterfaces;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final SamWithReceiverResolver samWithReceiverResolver;

    @Override
    @Nullable
    public SamConstructorDescriptor resolveSamConstructor(@NotNull DeclarationDescriptor constructorOwner, @NotNull Function0<? extends ClassifierDescriptor> classifier) {
        Intrinsics.checkParameterIsNotNull((Object)constructorOwner, (String)"constructorOwner");
        Intrinsics.checkParameterIsNotNull(classifier, (String)"classifier");
        ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)classifier.invoke();
        if (!(classifierDescriptor instanceof LazyJavaClassDescriptor) || ((LazyJavaClassDescriptor)classifierDescriptor).getFunctionTypeForSamInterface() == null) {
            return null;
        }
        return SingleAbstractMethodUtils.createSamConstructorFunction(constructorOwner, (JavaClassDescriptor)classifierDescriptor);
    }

    @Override
    @Nullable
    public <D extends FunctionDescriptor> D resolveSamAdapter(@NotNull D original) {
        FunctionDescriptor functionDescriptor2;
        Intrinsics.checkParameterIsNotNull(original, (String)"original");
        if (!SingleAbstractMethodUtils.isSamAdapterNecessary(original)) {
            functionDescriptor2 = null;
        } else if (original instanceof JavaClassConstructorDescriptor) {
            SamAdapterDescriptor<JavaClassConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterConstructor((JavaClassConstructorDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor2 = samAdapterDescriptor;
        } else if (original instanceof JavaMethodDescriptor) {
            SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterFunction((JavaMethodDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor2 = samAdapterDescriptor;
        } else {
            functionDescriptor2 = null;
        }
        return (D)functionDescriptor2;
    }

    @Override
    @Nullable
    public SimpleType resolveFunctionTypeIfSamInterface(@NotNull JavaClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        return this.functionTypesForSamInterfaces.computeIfAbsent(classDescriptor, (Function0<SimpleType>)((Function0)new Function0<SimpleType>(this, classDescriptor){
            final /* synthetic */ SamConversionResolverImpl this$0;
            final /* synthetic */ JavaClassDescriptor $classDescriptor;

            @Nullable
            public final SimpleType invoke() {
                FunctionDescriptor functionDescriptor2 = SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(this.$classDescriptor);
                if (functionDescriptor2 == null) {
                    return null;
                }
                FunctionDescriptor abstractMethod = functionDescriptor2;
                SamWithReceiverResolver samWithReceiverResolver = this.this$0.getSamWithReceiverResolver();
                FunctionDescriptor functionDescriptor3 = abstractMethod;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"abstractMethod");
                boolean shouldConvertFirstParameterToDescriptor = samWithReceiverResolver.shouldConvertFirstSamParameterToReceiver(functionDescriptor3);
                return SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod, shouldConvertFirstParameterToDescriptor);
            }
            {
                this.this$0 = samConversionResolverImpl;
                this.$classDescriptor = javaClassDescriptor;
                super(0);
            }
        }));
    }

    @NotNull
    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public final SamWithReceiverResolver getSamWithReceiverResolver() {
        return this.samWithReceiverResolver;
    }

    public SamConversionResolverImpl(@NotNull StorageManager storageManager, @NotNull SamWithReceiverResolver samWithReceiverResolver) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)samWithReceiverResolver, (String)"samWithReceiverResolver");
        this.storageManager = storageManager;
        this.samWithReceiverResolver = samWithReceiverResolver;
        this.functionTypesForSamInterfaces = this.storageManager.createCacheWithNullableValues();
    }
}

