/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0011\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010!\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\fj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "", "packageFqName", "", "(Ljava/lang/String;)V", "metadataParts", "", "getMetadataParts", "()Ljava/util/Set;", "getPackageFqName", "()Ljava/lang/String;", "packageParts", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "parts", "getParts", "addMetadataPart", "", "shortName", "addPart", "partShortName", "facadeShortName", "addTo", "builder", "Lorg/jetbrains/kotlin/serialization/jvm/JvmPackageTable$PackageTable$Builder;", "equals", "", "other", "getMultifileFacadeName", "hashCode", "", "plusAssign", "removePart", "toString", "descriptor.loader.java"})
public final class PackageParts {
    private final LinkedHashMap<String, String> packageParts;
    @NotNull
    private final Set<String> metadataParts;
    @NotNull
    private final String packageFqName;

    @NotNull
    public final Set<String> getParts() {
        Set<String> set = this.packageParts.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"packageParts.keys");
        return set;
    }

    @NotNull
    public final Set<String> getMetadataParts() {
        return this.metadataParts;
    }

    public final void addPart(@NotNull String partShortName, @Nullable String facadeShortName) {
        Intrinsics.checkParameterIsNotNull((Object)partShortName, (String)"partShortName");
        Map map2 = this.packageParts;
        String string = facadeShortName;
        map2.put(partShortName, string);
    }

    public final void removePart(@NotNull String shortName) {
        Intrinsics.checkParameterIsNotNull((Object)shortName, (String)"shortName");
        this.packageParts.remove(shortName);
    }

    public final void addMetadataPart(@NotNull String shortName) {
        Intrinsics.checkParameterIsNotNull((Object)shortName, (String)"shortName");
        Set<String> set = this.metadataParts;
        if (set == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
        }
        TypeIntrinsics.asMutableSet(set).add(shortName);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTo(@NotNull JvmPackageTable.PackageTable.Builder builder) {
        Object object;
        Object $receiver;
        JvmPackageTable.PackageTable.Builder builder2;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Object object2 = this.getParts();
        if (!object2.isEmpty()) {
            Object partNames;
            Object element$iv$iv;
            void $receiver$iv$iv;
            object2 = JvmPackageTable.PackageParts.newBuilder();
            builder2 = builder;
            $receiver = object2;
            ((JvmPackageTable.PackageParts.Builder)$receiver).setPackageFqName(this.packageFqName);
            Map facadeNameToId = new LinkedHashMap();
            Object $receiver$iv = this.getParts();
            Iterable iterable = $receiver$iv;
            Pair destination$iv$iv = new LinkedHashMap();
            Iterator<Object> iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                String key$iv$iv = this.getMultifileFacadeName(it);
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Object object4 = destination$iv$iv;
            Comparator comparator = ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder());
            $receiver$iv = MapsKt.toSortedMap((Map)object4, (Comparator)comparator);
            Iterator iterator3 = $receiver$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Pair pair2;
                destination$iv$iv = pair2 = iterator3.next();
                String facadeName = (String)destination$iv$iv.getKey();
                destination$iv$iv = pair2;
                partNames = (List)destination$iv$iv.getValue();
                for (String partName : CollectionsKt.sorted((Iterable)((Iterable)partNames))) {
                    Object object5;
                    void $receiver$iv2;
                    ((JvmPackageTable.PackageParts.Builder)$receiver).addClassName(partName);
                    if (facadeName == null) continue;
                    element$iv$iv = facadeNameToId;
                    int n = 1;
                    object4 = $receiver;
                    Object value$iv = $receiver$iv2.get(facadeName);
                    if (value$iv == null) {
                        Integer answer$iv = facadeNameToId.size();
                        $receiver$iv2.put(facadeName, answer$iv);
                        object5 = answer$iv;
                    } else {
                        object5 = value$iv;
                    }
                    Object v = object5;
                    ((JvmPackageTable.PackageParts.Builder)object4).addMultifileFacadeId(n + ((Number)v).intValue());
                }
            }
            partNames = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)facadeNameToId.values(), (Iterable)facadeNameToId.keySet());
            Comparator comparator2 = new Comparator<Pair<? extends Integer, ? extends String>>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    Object receiver = a;
                    Comparable comparable = (Comparable)((Pair)receiver).getFirst();
                    receiver = b;
                    Comparable comparable2 = comparable;
                    Object object = ((Pair)receiver).getFirst();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)object));
                }
            };
            for (Pair pair2 : CollectionsKt.sortedWith((Iterable)partNames, (Comparator)comparator2)) {
                boolean bl;
                int facadeId = ((Number)pair2.component1()).intValue();
                String facadeName = (String)pair2.component2();
                boolean bl2 = bl = facadeId == ((JvmPackageTable.PackageParts.Builder)$receiver).getMultifileFacadeNameCount();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Multifile facades are loaded incorrectly: " + facadeNameToId;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                ((JvmPackageTable.PackageParts.Builder)$receiver).addMultifileFacadeName(facadeName);
            }
            object = object2;
            builder2.addPackageParts((JvmPackageTable.PackageParts.Builder)object);
        }
        if (!(object2 = (Collection)this.metadataParts).isEmpty()) {
            object2 = JvmPackageTable.PackageParts.newBuilder();
            builder2 = builder;
            $receiver = object2;
            ((JvmPackageTable.PackageParts.Builder)$receiver).setPackageFqName(this.packageFqName);
            ((JvmPackageTable.PackageParts.Builder)$receiver).addAllClassName(CollectionsKt.sorted((Iterable)this.metadataParts));
            object = object2;
            builder2.addMetadataParts((JvmPackageTable.PackageParts.Builder)object);
        }
    }

    @Nullable
    public final String getMultifileFacadeName(@NotNull String partShortName) {
        Intrinsics.checkParameterIsNotNull((Object)partShortName, (String)"partShortName");
        return this.packageParts.get(partShortName);
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull PackageParts other) {
        void $receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Map map2 = other.packageParts;
        Object object2 = map2.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            String partShortName = (String)object3.getKey();
            object3 = object;
            String facadeShortName = (String)object3.getValue();
            this.addPart(partShortName, facadeShortName);
        }
        object = other.metadataParts;
        object2 = this;
        for (Object element$iv : $receiver$iv) {
            String p1 = (String)element$iv;
            ((PackageParts)object2).addMetadataPart(p1);
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PackageParts && Intrinsics.areEqual((Object)((PackageParts)other).packageFqName, (Object)this.packageFqName) && Intrinsics.areEqual(((PackageParts)other).packageParts, this.packageParts) && Intrinsics.areEqual(((PackageParts)other).metadataParts, this.metadataParts);
    }

    public int hashCode() {
        return (this.packageFqName.hashCode() * 31 + this.packageParts.hashCode()) * 31 + ((Object)this.metadataParts).hashCode();
    }

    @NotNull
    public String toString() {
        return SetsKt.plus(this.getParts(), (Iterable)this.metadataParts).toString();
    }

    @NotNull
    public final String getPackageFqName() {
        return this.packageFqName;
    }

    public PackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        this.packageFqName = packageFqName;
        PackageParts packageParts = this;
        Cloneable cloneable2 = new LinkedHashMap();
        packageParts.packageParts = cloneable2;
        packageParts = this;
        cloneable2 = new LinkedHashSet();
        packageParts.metadataParts = (Set)((Object)cloneable2);
    }
}

