/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCatchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTryImpl;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/TryCatchExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateTryCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktTry", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "ir.psi2ir"})
public final class TryCatchExpressionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateTryCatch(@NotNull KtTryExpression ktTry) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)ktTry, (String)"ktTry");
        KotlinType resultType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktTry);
        IrTryImpl irTryCatch = new IrTryImpl(PsiUtilsKt.getStartOffset((PsiElement)ktTry), PsiUtilsKt.getEndOffset((PsiElement)ktTry), resultType);
        StatementGenerator statementGenerator = this.getStatementGenerator();
        KtBlockExpression ktBlockExpression = ktTry.getTryBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"ktTry.tryBlock");
        irTryCatch.setTryResult(statementGenerator.generateExpression(ktBlockExpression));
        for (KtCatchClause ktCatchClause : ktTry.getCatchClauses()) {
            KtExpression ktCatchBody;
            KtParameter ktCatchParameter;
            if (ktCatchClause.getCatchParameter() == null) {
                Intrinsics.throwNpe();
            }
            if (ktCatchClause.getCatchBody() == null) {
                Intrinsics.throwNpe();
            }
            WritableSlice<KtParameter, VariableDescriptor> writableSlice = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.VALUE_PARAMETER");
            VariableDescriptor catchParameterDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktCatchParameter);
            StatementGenerator statementGenerator2 = this.getStatementGenerator();
            KtExpression ktExpression = ktCatchBody;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ktCatchBody");
            IrExpression irCatchResult = statementGenerator2.generateExpression(ktExpression);
            int n = PsiUtilsKt.getStartOffset((PsiElement)ktCatchClause);
            int n2 = PsiUtilsKt.getEndOffset((PsiElement)ktCatchClause);
            VariableDescriptor variableDescriptor = catchParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"catchParameterDescriptor");
            IrCatchImpl irCatch = new IrCatchImpl(n, n2, variableDescriptor, irCatchResult);
            irTryCatch.getCatches().add(irCatch);
        }
        IrTryImpl irTryImpl = irTryCatch;
        KtFinallySection ktFinallySection = ktTry.getFinallyBlock();
        if (ktFinallySection != null) {
            KtFinallySection ktFinallySection2 = ktFinallySection;
            IrTryImpl irTryImpl2 = irTryImpl;
            KtFinallySection it = ktFinallySection2;
            StatementGenerator statementGenerator3 = this.getStatementGenerator();
            KtBlockExpression ktBlockExpression2 = it.getFinalExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression2, (String)"it.finalExpression");
            IrExpression irExpression2 = statementGenerator3.generateExpression(ktBlockExpression2);
            irTryImpl = irTryImpl2;
            irExpression = irExpression2;
        } else {
            irExpression = null;
        }
        irTryImpl.setFinallyExpression(irExpression);
        return irTryCatch;
    }

    public TryCatchExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

