/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (supertypeLoopsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeLoopsResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (variableTypeAndInitializerResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableTypeAndInitializerResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (overloadChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadChecker", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (functionsTypingVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionsTypingVisitor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (destructuringDeclarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringDeclarationResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (modifiersChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersChecker", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (wrappedTypeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedTypeFactory", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        ArrayList supertypes2 = Lists.newArrayList();
        List<KtSuperTypeListEntry> delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = this.resolveSuperTypeListEntries(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor, supertypes2);
        if (supertypes2.isEmpty()) {
            SimpleType defaultSupertype = correspondingClassOrObject == null ? this.builtIns.getAnyType() : this.getDefaultSupertype(correspondingClassOrObject, trace, classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
            DescriptorResolver.addValidSupertype(supertypes2, defaultSupertype);
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<KotlinType> supertypes2, KotlinType declaredSupertype) {
        if (!declaredSupertype.isError()) {
            supertypes2.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result2) {
        for (KotlinType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    private KotlinType getDefaultSupertype(KtPureClassOrObject ktClass, BindingTrace trace, boolean isAnnotation) {
        if (ktClass instanceof KtEnumEntry) {
            KtEnumEntry enumEntry = (KtEnumEntry)ktClass;
            KtClassOrObject parent2 = KtStubbedPsiUtil.getContainingDeclaration(enumEntry, KtClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent2);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(enumEntry.getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        if (isAnnotation) {
            return this.builtIns.getAnnotationType();
        }
        return this.builtIns.getAnyType();
    }

    public Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSuperTypeListEntries"));
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype = resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType, supertype);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNullableSupertypeAndStripQuestionMarks"));
        }
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement, @NotNull KotlinType type2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType2 = (KtUserType)typeElement;
            List<KtTypeProjection> typeArguments = userType2.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!type2.isError() && SpecialTypesKt.getAbbreviatedType(type2) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type2) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type2)) {
            trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type2));
        }
    }

    public static Visibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(final @NotNull LexicalScope scope2, final @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter, int index2, final @NotNull KotlinType type2, final @NotNull BindingTrace trace) {
        Function0<List<VariableDescriptor>> destructuringVariables;
        KtDestructuringDeclaration destructuringDeclaration;
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        KotlinType varargElementType = null;
        KotlinType variableType = type2;
        if (valueParameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        KtModifierList modifierList = valueParameter.getModifierList();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, valueParameter.getModifierList(), trace);
        Annotations valueParameterAnnotations = Annotations.Companion.getEMPTY();
        if (modifierList != null) {
            if (valueParameter.hasValOrVar()) {
                AnnotationSplitter annotationSplitter = AnnotationSplitter.create(this.storageManager, allAnnotations, SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER)));
                valueParameterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
            } else {
                valueParameterAnnotations = allAnnotations;
            }
        }
        if ((destructuringDeclaration = valueParameter.getDestructuringDeclaration()) != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueParameter, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.DestructuringLambdaParameters), (Object)this.languageVersionSettings)));
            }
            destructuringVariables = new Function0<List<VariableDescriptor>>(){

                public List<VariableDescriptor> invoke() {
                    assert (owner.getDispatchReceiverParameter() == null) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                    LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope2, owner.getExtensionReceiverParameter());
                    List<VariableDescriptor> result2 = DescriptorResolver.this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope2, destructuringDeclaration, new TransientReceiver(type2), null, ExpressionTypingContext.newContext(trace, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE));
                    DescriptorResolver.this.modifiersChecker.withTrace(trace).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                    return result2;
                }
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore(valueParameter) ? Name.special("<anonymous parameter " + index2 + ">") : KtPsiUtil.safeName(valueParameter.getName())) : Name.special("<name for destructuring parameter " + index2 + ">");
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index2, valueParameterAnnotations, parameterName, variableType, valueParameter.hasDefaultValue(), valueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType, KotlinSourceElementKt.toSourceElement(valueParameter), (Function0<? extends List<? extends VariableDescriptor>>)destructuringVariables);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        SimpleType primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType);
        if (primitiveArrayType != null) {
            SimpleType simpleType2 = primitiveArrayType;
            if (simpleType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
            }
            return simpleType2;
        }
        SimpleType simpleType3 = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (simpleType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        return simpleType3;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> descriptors2 = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters, trace);
        for (TypeParameterDescriptorImpl descriptor2 : descriptors2) {
            extensibleScope.addClassifierDescriptor(descriptor2);
        }
        return descriptors2;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            KtTypeParameter typeParameter = typeParameters.get(i);
            result2.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(final DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, final KtTypeParameter typeParameter, int index2, final BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter));
        }
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter.getModifierList(), trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations2, typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter.getVariance(), KtPsiUtil.safeName(typeParameter.getName()), index2, KotlinSourceElementKt.toSourceElement(typeParameter), new Function1<KotlinType, Void>(){

            public Void invoke(KotlinType type2) {
                if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                    trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeParameter));
                }
                return null;
            }
        }, this.supertypeLoopsResolver);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, KotlinSourceElementKt.toSourceElement(object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : (PsiElement)object, constructorDescriptor);
        }
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = constructorDescriptor;
        if (classConstructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        return classConstructorDescriptorImpl;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration2, @NotNull DeclarationDescriptor descriptor2, LexicalScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        ArrayList upperBoundCheckRequests = Lists.newArrayList();
        List<KtTypeParameter> typeParameters = declaration2.getTypeParameters();
        HashMap parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            KtTypeParameter ktTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type2));
        }
        for (KtTypeConstraint constraint : declaration2.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            KtTypeReference boundTypeReference = constraint.getBoundTypeReference();
            KotlinType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration2 instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace, upperBoundCheckRequests);
            this.checkNamesInConstraints(declaration2, descriptor2, scope2, trace);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace, @NotNull List<UpperBoundCheckRequest> requests) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkUpperBoundTypes"));
        }
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkUpperBoundTypes"));
        }
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair> allBounds = new HashSet<Pair>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!upperBound.isError()) {
                if (!allBounds.add(new Pair((Object)typeParameterName, (Object)upperBound.getConstructor()))) {
                    trace.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind2;
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor == null || (kind2 = classDescriptor.getKind()) != ClassKind.CLASS && kind2 != ClassKind.ENUM_CLASS && kind2 != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull KtTypeParameter typeParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter))) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        for (KtTypeConstraint constraint : declaration2.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name2;
            ClassifierDescriptor classifier;
            KtSimpleNameExpression nameExpression2 = constraint.getSubjectTypeParameterName();
            if (nameExpression2 == null || (classifier = ScopeUtilsKt.findClassifier(scope2, name2 = nameExpression2.getReferencedNameAsName(), NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier.getContainingDeclaration() == descriptor2) continue;
            if (classifier != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression2, constraint, declaration2));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression2, classifier);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression2, nameExpression2));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace) {
        if (upperBoundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBoundType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkUpperBoundType"));
        }
        if (!TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope2, @NotNull KtParameter parameter, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        KotlinType type2 = this.resolveParameterType(scope2, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type2, trace, scope2);
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptor;
    }

    private KotlinType resolveParameterType(LexicalScope scope2, KtParameter parameter, BindingTrace trace) {
        KtTypeReference typeReference = parameter.getTypeReference();
        KotlinType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter, @NotNull KotlinType type2, BindingTrace trace, @NotNull LexicalScope scope2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter.getModifierList(), trace), KtPsiUtil.safeName(parameter.getName()), type2, false, false, KotlinSourceElementKt.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope2, @NotNull KtTypeAlias typeAlias2, final @NotNull BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeAliasDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeAliasDescriptor"));
        }
        if (typeAlias2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAlias", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeAliasDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeAliasDescriptor"));
        }
        if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
            trace.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias2));
        }
        KtModifierList modifierList = typeAlias2.getModifierList();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(typeAlias2, DescriptorResolver.getDefaultVisibility(typeAlias2, containingDeclaration));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList, trace);
        Name name2 = KtPsiUtil.safeName(typeAlias2.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(typeAlias2);
        final LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace, containingDeclaration, allAnnotations, name2, sourceElement, visibility);
        List<KtTypeParameter> typeParameters = typeAlias2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope2, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope2, typeParameters, trace);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias2, trace);
            this.resolveGenericBounds(typeAlias2, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        final KtTypeReference typeReference = typeAlias2.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name2.asString()), ErrorUtils.createErrorType(name2.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            PsiElement typeAliasKeyword = typeAlias2.getTypeAliasKeyword();
            trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)(typeAliasKeyword != null ? typeAliasKeyword : typeAlias2), (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.TypeAliases), (Object)this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name2.asString()), ErrorUtils.createErrorType(name2.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, this.storageManager.createRecursionTolerantLazyValue(new Function0<SimpleType>(){

                public SimpleType invoke() {
                    return DescriptorResolver.this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
                }
            }, ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())), this.storageManager.createRecursionTolerantLazyValue(new Function0<SimpleType>(){

                public SimpleType invoke() {
                    return DescriptorResolver.this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor);
                }
            }, ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())));
        }
        trace.record(BindingContext.TYPE_ALIAS, typeAlias2, typeAliasDescriptor);
        LazyTypeAliasDescriptor lazyTypeAliasDescriptor = typeAliasDescriptor;
        if (lazyTypeAliasDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeAliasDescriptor"));
        }
        return lazyTypeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias2, @NotNull BindingTrace trace) {
        if (typeAlias2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAlias", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNoGenericBoundsOnTypeAliasParameters"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNoGenericBoundsOnTypeAliasParameters"));
        }
        for (KtTypeParameter typeParameter : typeAlias2.getTypeParameters()) {
            KtTypeReference bound = typeParameter.getExtendsBound();
            if (bound == null) continue;
            trace.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound));
        }
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtProperty property2, final @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        KotlinType kotlinType;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scopeForDeclarationResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForDeclarationResolution", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scopeForInitializerResolution2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForInitializerResolution", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        KtModifierList modifierList = property2.getModifierList();
        boolean isVar = property2.isVar();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(property2, DescriptorResolver.getDefaultVisibility(property2, containingDeclaration));
        Modality modality = containingDeclaration instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers(property2, DescriptorResolver.getDefaultModality(containingDeclaration, visibility, property2.hasBody()), trace.getBindingContext(), containingDeclaration) : Modality.FINAL;
        final AnnotationSplitter.PropertyWrapper wrapper = new AnnotationSplitter.PropertyWrapper(property2);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList, trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)new Function0<Set<AnnotationUseSiteTarget>>(){

            public Set<AnnotationUseSiteTarget> invoke() {
                return AnnotationSplitter.getTargetSet(false, trace.getBindingContext(), wrapper);
            }
        });
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, propertyAnnotations, modality, visibility, isVar, KtPsiUtil.safeName(property2.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(property2), modifierList != null && modifierList.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.CONST_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.HEADER_KEYWORD) || containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).isHeader(), modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.EXTERNAL_KEYWORD), property2.hasDelegate());
        wrapper.setDescriptor(propertyDescriptor);
        KotlinType receiverType2 = null;
        List<KtTypeParameter> typeParameters = property2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, containingDeclaration, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution2, containingDeclaration, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters, trace);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds(property2, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType2 = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType2);
        LexicalScope scopeForInitializer = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType typeIfKnown = this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, scopeForInitializer, property2, dataFlowInfo, trace, false);
        PropertyGetterDescriptorImpl getter = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, property2, propertyDescriptor, annotationSplitter, trace, typeIfKnown);
        KotlinType kotlinType2 = kotlinType = typeIfKnown != null ? typeIfKnown : getter.getReturnType();
        assert (kotlinType != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, scopeForInitializer, property2, dataFlowInfo, kotlinType, trace);
        propertyDescriptor.setType(kotlinType, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDeclaration), receiverDescriptor);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, property2, propertyDescriptor, annotationSplitter, trace);
        propertyDescriptor.initialize(getter, setter);
        trace.record(BindingContext.VARIABLE, property2, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull KtDeclaration declaration2, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        boolean definedInClass2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        ClassifierDescriptor classifier = type2.getConstructor().getDeclarationDescriptor();
        if (classifier == null || !DescriptorUtils.isAnonymousObject(classifier) || DescriptorUtils.isLocal(descriptor2)) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
            }
            return kotlinType;
        }
        boolean bl = definedInClass2 = DescriptorUtils.getParentOfType(descriptor2, ClassDescriptor.class) != null;
        if (!definedInClass2 || !Visibilities.isPrivate(descriptor2.getVisibility())) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                KotlinType kotlinType = type2.getConstructor().getSupertypes().iterator().next();
                if (kotlinType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
                }
                return kotlinType;
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration2, type2.getConstructor().getSupertypes()));
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        return kotlinType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace) {
        if (scopeWithTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeWithTypeParameters", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (annotationSplitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationSplitter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        KtPropertyAccessor setter = property2.getSetter();
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter != null) {
            KotlinType returnType2;
            CompositeAnnotations annotations2 = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter.getModifierList(), trace)}));
            KtParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveMemberModalityFromModifiers(setter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(setter, propertyDescriptor.getVisibility()), false, setter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property2.hasModifier(KtTokens.INLINE_KEYWORD) || setter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(setter));
            KtTypeReference returnTypeReference = setter.getReturnTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType2 = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace, true))) {
                trace.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter != null) {
                KotlinType type2;
                KtTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type2 = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace, true);
                    if (!TypeUtils.equalTypes(type2, inType = propertyDescriptor.getType())) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property2.isVar()) {
            Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterAnnotations, !property2.hasDelegate(), false, property2.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property2.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KotlinType propertyTypeIfKnown) {
        KotlinType getterType;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scopeForDeclarationResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForDeclarationResolution", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (annotationSplitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationSplitter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        KtPropertyAccessor getter = property2.getGetter();
        if (getter != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter.getModifierList(), trace)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(getter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(getter, propertyDescriptor.getVisibility()), false, getter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property2.hasModifier(KtTokens.INLINE_KEYWORD) || getter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(getter));
            getterType = this.determineGetterReturnType(scopeForDeclarationResolution, trace, getterDescriptor, getter, propertyTypeIfKnown);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            Annotations getterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterAnnotations, !property2.hasDelegate(), false, property2.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType != null ? getterType : VariableTypeAndInitializerResolver.STUB_FOR_PROPERTY_WITHOUT_TYPE);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = getterDescriptor;
        if (propertyGetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        return propertyGetterDescriptorImpl;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter, @Nullable KotlinType propertyTypeIfKnown) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "determineGetterReturnType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "determineGetterReturnType"));
        }
        if (getterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "determineGetterReturnType"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "determineGetterReturnType"));
        }
        KtTypeReference returnTypeReference = getter.getReturnTypeReference();
        if (returnTypeReference != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property2 = getter.getProperty();
        if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null && getter.hasBody() && !getter.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace, scope2, DataFlowInfoFactory.EMPTY, getter, getterDescriptor);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(final @NotNull BindingTrace trace, final @NotNull LexicalScope scope2, final @NotNull DataFlowInfo dataFlowInfo, final @NotNull KtDeclarationWithBody function2, final @NotNull FunctionDescriptor functionDescriptor2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        KotlinType kotlinType = this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)new Function0<KotlinType>(){

            public KotlinType invoke() {
                PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace);
                KotlinType type2 = DescriptorResolver.this.expressionTypingServices.getBodyExpressionType(trace, scope2, dataFlowInfo, function2, functionDescriptor2);
                KotlinType result2 = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor2, function2, type2, trace);
                DescriptorResolver.this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace, result2);
                return result2;
            }
        });
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "inferReturnTypeFromExpressionBody"));
        }
        return kotlinType;
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope2, @NotNull KtParameter parameter, final BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        KotlinType type2 = this.resolveParameterType(scope2, parameter, trace);
        Name name2 = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        KtModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        final AnnotationSplitter.PropertyWrapper propertyWrapper = new AnnotationSplitter.PropertyWrapper(parameter);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, parameter.getModifierList(), trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)new Function0<Set<AnnotationUseSiteTarget>>(){

            public Set<AnnotationUseSiteTarget> invoke() {
                return AnnotationSplitter.getTargetSet(true, trace.getBindingContext(), propertyWrapper);
            }
        });
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(parameter, Modality.FINAL, trace.getBindingContext(), classDescriptor), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name2, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(parameter), false, false, classDescriptor.isHeader(), modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD), false, false);
        propertyWrapper.setDescriptor(propertyDescriptor);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), (ReceiverParameterDescriptor)null);
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object)annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations) : null;
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2.isError()) {
            return;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<KtTypeReference> ktTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            assert (ktTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            DescriptorResolver.checkBounds(ktTypeArguments.get(0), flexibleType.getLowerBound(), trace);
            DescriptorResolver.checkBounds(ktTypeArguments.get(1), flexibleType.getUpperBound(), trace);
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor substitutor3 = TypeSubstitutor.create(type2);
        for (int i = 0; i < ktTypeArguments.size(); ++i) {
            KtTypeReference ktTypeArgument = ktTypeArguments.get(i);
            if (ktTypeArgument == null) continue;
            KotlinType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, typeParameterDescriptor, substitutor3, trace);
        }
    }

    public static void checkBounds(@NotNull KtTypeReference jetTypeArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor3, @NotNull BindingTrace trace) {
        if (jetTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor3.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static void checkBoundsInTypeAlias(@NotNull TypeAliasExpansionReportStrategy reportStrategy, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor3) {
        if (reportStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportStrategy", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBoundsInTypeAlias"));
        }
        if (unsubstitutedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBoundsInTypeAlias"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBoundsInTypeAlias"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBoundsInTypeAlias"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBoundsInTypeAlias"));
        }
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor3.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            reportStrategy.boundsViolationInSubstitution(substitutedBound, unsubstitutedArgument, typeArgument, typeParameterDescriptor);
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope2);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/kotlin/resolve/DescriptorResolver", "isInsideOuterClassOrItsSubclass"));
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getContainingClass"));
        }
        return DescriptorUtils.getParentOfType(scope2.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace, @NotNull KtFile file2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        FqName fqName2 = file2.getPackageFqName();
        Set files2 = trace.get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files2 == null) {
            files2 = Sets.newIdentityHashSet();
        }
        files2.add(file2);
        trace.record(BindingContext.PACKAGE_TO_FILES, fqName2, files2);
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

