/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a,\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isScopeForDefaultParameterValuesOf", "", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
public final class CoroutineCallCheckerKt {
    private static final boolean isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return $receiver instanceof LexicalScope && Intrinsics.areEqual((Object)((Object)((LexicalScope)$receiver).getKind()), (Object)((Object)LexicalScopeKind.DEFAULT_VALUE)) && Intrinsics.areEqual((Object)((LexicalScope)$receiver).getOwnerDescriptor(), (Object)enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Pair diagnosticData = TuplesKt.to((Object)((Object)LanguageFeature.Coroutines), (Object)languageVersionSettings);
        switch (CoroutineCallCheckerKt$WhenMappings.$EnumSwitchMapping$0[languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            }
        }
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object object = enclosingCallableDescriptor.getExtensionReceiverParameter();
        if (object == null || (object = object.getValue()) == null) {
            return;
        }
        Object enclosingSuspendReceiverValue = object;
        checkRestrictsSuspension.1 isRestrictsSuspensionReceiver$ = checkRestrictsSuspension.1.INSTANCE;
        Function2<ReceiverValue, ReceiverValue, Boolean> sameInstance$ = new Function2<ReceiverValue, ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver, @Nullable ReceiverValue other) {
                CallableDescriptor callableDescriptor;
                DeclarationDescriptor referenceTarget;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2;
                KtReferenceExpression referenceExpression;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if (other == null) {
                    return false;
                }
                if ($receiver == other) {
                    return true;
                }
                ReceiverValue receiverValue = other;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                KtReferenceExpression ktReferenceExpression = referenceExpression = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
                if (ktReferenceExpression != null) {
                    KtReferenceExpression ktReferenceExpression2;
                    KtReferenceExpression it = ktReferenceExpression2 = ktReferenceExpression;
                    declarationDescriptor2 = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
                } else {
                    declarationDescriptor2 = null;
                }
                if (!((declarationDescriptor = (referenceTarget = declarationDescriptor2)) instanceof CallableDescriptor)) {
                    declarationDescriptor = null;
                }
                return $receiver == ((callableDescriptor = (CallableDescriptor)declarationDescriptor) != null && (callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null ? callableDescriptor.getValue() : null);
            }
            {
                this.$context = callCheckerContext;
                super(2);
            }
        };
        if (!isRestrictsSuspensionReceiver$.invoke((ReceiverValue)enclosingSuspendReceiverValue)) {
            return;
        }
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, resolvedCall2.getExtensionReceiver())) {
            ReceiverParameterDescriptor receiverParameterDescriptor = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (isRestrictsSuspensionReceiver$.invoke(receiverParameterDescriptor.getValue())) {
                return;
            }
        }
        context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on(reportOn));
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, @NotNull FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(@NotNull CallableDescriptor enclosingCallableDescriptor, @NotNull ResolvedCall resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingCallableDescriptor, resolvedCall2, reportOn, context);
    }
}

