/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.ConstApplicability;
import org.jetbrains.kotlin.resolve.checkers.ConstModifierCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "canBeConst", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "constModifierPsiElement", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "check", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkCanBeConst", "Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;", "frontend"})
public final class ConstModifierChecker
implements SimpleDeclarationChecker {
    public static final ConstModifierChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        PsiElement constModifierPsiElement;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration2.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration2.getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement3 = constModifierPsiElement = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"constModifierPsiElement");
        Diagnostic diagnostic = this.checkCanBeConst(declaration2, psiElement3, (VariableDescriptor)descriptor2).getDiagnostic();
        if (diagnostic != null) {
            diagnosticHolder.report(diagnostic);
        }
    }

    public final boolean canBeConst(@NotNull KtDeclaration declaration2, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)constModifierPsiElement, (String)"constModifierPsiElement");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return this.checkCanBeConst(declaration2, constModifierPsiElement, descriptor2).getCanBeConst();
    }

    private final ConstApplicability checkCanBeConst(KtDeclaration declaration2, PsiElement constModifierPsiElement, VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return ConstModifierCheckerKt.access$nonApplicable(Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDeclaration).getKind()), (Object)((Object)ClassKind.OBJECT)) ^ true) {
            return ConstModifierCheckerKt.access$nonApplicable(Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement));
        }
        if (!(declaration2 instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (((KtProperty)declaration2).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration2).getDelegate();
            if (ktPropertyDelegate == null) {
                Intrinsics.throwNpe();
            }
            return ConstModifierCheckerKt.access$nonApplicable(Errors.CONST_VAL_WITH_DELEGATE.on((PsiElement)ktPropertyDelegate));
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (!propertyGetterDescriptor.isDefault()) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration2).getGetter();
                if (ktPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                return ConstModifierCheckerKt.access$nonApplicable(Errors.CONST_VAL_WITH_GETTER.on(ktPropertyAccessor));
            }
        }
        if (((PropertyDescriptor)descriptor2).getType().isError()) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (!ConstUtilKt.canBeUsedForConstVal(((PropertyDescriptor)descriptor2).getType())) {
            return ConstModifierCheckerKt.access$nonApplicable(Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType()));
        }
        if (((KtProperty)declaration2).getInitializer() == null) {
            return ConstModifierCheckerKt.access$nonApplicable(Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement));
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration2).getInitializer();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return ConstModifierCheckerKt.access$nonApplicable(Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression)));
        }
        return ConstApplicability.Applicable.INSTANCE;
    }

    private ConstModifierChecker() {
        INSTANCE = this;
    }

    static {
        new ConstModifierChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration2, descriptor2, diagnosticHolder, bindingContext2, languageVersionSettings);
    }
}

