/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.Printer;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static LexicalScope makeScopeForPropertyHeader(@NotNull LexicalScope parent2, final @NotNull PropertyDescriptor propertyDescriptor) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForPropertyHeader"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForPropertyHeader"));
        }
        return new LexicalScopeImpl(parent2, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_HEADER, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameterDescriptor : propertyDescriptor.getTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameterDescriptor);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public static LexicalScope makeScopeForPropertyInitializer(@NotNull LexicalScope propertyHeader, @NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyHeader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyHeader", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForPropertyInitializer"));
        }
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(propertyHeader, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_INITIALIZER_OR_DELEGATE);
        if (lexicalScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForPropertyInitializer"));
        }
        return lexicalScopeImpl;
    }

    @NotNull
    public static LexicalScope makeScopeForDelegateConventionFunctions(@NotNull LexicalScope parent2, @NotNull VariableDescriptorWithAccessors variableDescriptor) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForDelegateConventionFunctions"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForDelegateConventionFunctions"));
        }
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(parent2, variableDescriptor, true, variableDescriptor.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_DELEGATE_METHOD);
        if (lexicalScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "makeScopeForDelegateConventionFunctions"));
        }
        return lexicalScopeImpl;
    }

    @NotNull
    public static String printStructure(@Nullable MemberScope scope2) {
        StringBuilder out = new StringBuilder();
        Printer p = new Printer(out);
        if (scope2 == null) {
            p.println("null");
        } else {
            scope2.printScopeStructure(p);
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/ScopeUtils", "printStructure"));
        }
        return string;
    }
}

