/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "()V", "allParametersReified", "", "subtype", "Lorg/jetbrains/kotlin/types/KotlinType;", "findStaticallyKnownSubtype", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "supertype", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isCastErased", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "isCastPossible", "lhsType", "rhsType", "platformToKotlinClassMap", "Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;", "isFinal", "type", "isRelated", "a", "b", "isTrait", "mapToPlatformClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "frontend"})
public final class CastDiagnosticsUtil {
    public static final CastDiagnosticsUtil INSTANCE;

    @JvmStatic
    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        Intrinsics.checkParameterIsNotNull((Object)lhsType, (String)"lhsType");
        Intrinsics.checkParameterIsNotNull((Object)rhsType, (String)"rhsType");
        Intrinsics.checkParameterIsNotNull((Object)platformToKotlinClassMap, (String)"platformToKotlinClassMap");
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (lhsType.isError()) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMap)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassDescriptor it;
        Object element$iv2;
        List<ClassDescriptor> aClasses = this.mapToPlatformClasses(a, platformToKotlinClassMap);
        List<ClassDescriptor> bClasses = this.mapToPlatformClasses(b, platformToKotlinClassMap);
        Iterable $receiver$iv = aClasses;
        for (Object element$iv2 : $receiver$iv) {
            it = (ClassDescriptor)element$iv2;
            if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        $receiver$iv = bClasses;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it = (ClassDescriptor)(element$iv2 = iterator2.next())));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformClasses(KotlinType type2, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        return CollectionsKt.plus(platformToKotlinClassMap.mapPlatformClass(descriptor2), (Object)descriptor2);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor it = classifierDescriptor;
        return it instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)it).getKind()), (Object)((Object)ClassKind.INTERFACE));
    }

    @JvmStatic
    public static final boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker2) {
        Intrinsics.checkParameterIsNotNull((Object)supertype, (String)"supertype");
        Intrinsics.checkParameterIsNotNull((Object)subtype, (String)"subtype");
        Intrinsics.checkParameterIsNotNull((Object)typeChecker2, (String)"typeChecker");
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeUtils.makeNotNullable(supertype)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"TypeUtils.makeNotNullable(subtype)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker2);
        }
        if (typeChecker2.isSubtypeOf(supertype, subtype)) {
            return false;
        }
        if (TypeUtils.isNonReifiedTypeParameter(subtype)) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker2.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        Map substitution2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)supertype, (String)"supertype");
        Intrinsics.checkParameterIsNotNull((Object)subtypeConstructor, (String)"subtypeConstructor");
        boolean bl2 = bl = !supertype.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            String string = "This method only makes sense for non-nullable types";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String $i$a$1$assert = "Can't create default type for " + subtypeConstructor;
            throw (Throwable)new IllegalStateException($i$a$1$assert.toString());
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        SimpleType subtypeWithVariables = descriptor2.getDefaultType();
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> variables = subtypeWithVariables.getConstructor().getParameters();
        Iterable iterable = $receiver$iv = (Iterable)variables;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void descriptor3;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeConstructor typeConstructor2 = descriptor3.getTypeConstructor();
            collection.add(typeConstructor2);
        }
        Set variableConstructors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult solution = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), (Predicate<TypeConstructor>)Predicates.in((Collection)variableConstructors));
            HashMap hashMap = Maps.newHashMap(solution.getSubstitution());
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap(solution.substitution)");
            substitution2 = hashMap;
        } else {
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)variables.size());
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMapWithExpec\u2026ojection>(variables.size)");
            substitution2 = hashMap;
        }
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable2 : variables) {
            TypeProjection value2 = (TypeProjection)substitution2.get(variable2.getTypeConstructor());
            if (value2 != null) continue;
            TypeConstructor typeConstructor3 = variable2.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"variable.typeConstructor");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable2);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeProjection, (String)"TypeUtils.makeStarProjection(variable)");
            substitution2.put(typeConstructor3, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution2).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = subtype.getConstructor().getParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (it.isReified()) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private CastDiagnosticsUtil() {
        INSTANCE = this;
    }

    static {
        new CastDiagnosticsUtil();
    }
}

