/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class TypeIntersector {
    public static boolean isIntersectionEmpty(@NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        if (typeA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeA", "org/jetbrains/kotlin/types/TypeIntersector", "isIntersectionEmpty"));
        }
        if (typeB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeB", "org/jetbrains/kotlin/types/TypeIntersector", "isIntersectionEmpty"));
        }
        return TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, new LinkedHashSet<KotlinType>(Arrays.asList(typeA, typeB))) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static KotlinType intersectTypes(@NotNull KotlinTypeChecker typeChecker2, @NotNull Collection<KotlinType> types) {
        if (typeChecker2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "org/jetbrains/kotlin/types/TypeIntersector", "intersectTypes"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/TypeIntersector", "intersectTypes"));
        }
        assert (!types.isEmpty()) : "Attempting to intersect empty collection of types, this case should be dealt with on the call site.";
        if (types.size() == 1) {
            return types.iterator().next();
        }
        KotlinType nothingOrNullableNothing = null;
        boolean allNullable = true;
        ArrayList<KotlinType> nullabilityStripped = new ArrayList<KotlinType>(types.size());
        for (KotlinType kotlinType : types) {
            if (kotlinType.isError()) continue;
            if (KotlinBuiltIns.isNothingOrNullableNothing(kotlinType)) {
                nothingOrNullableNothing = kotlinType;
            }
            allNullable &= kotlinType.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(kotlinType));
        }
        if (nothingOrNullableNothing != null) {
            return TypeUtils.makeNullableAsSpecified(nothingOrNullableNothing, allNullable);
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType("Intersection of error types: " + types);
        }
        ArrayList<KotlinType> resultingTypes = new ArrayList<KotlinType>();
        block1: for (KotlinType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker2, type3)) {
                boolean relativeToAll = true;
                for (KotlinType other : nullabilityStripped) {
                    boolean relative;
                    boolean mayBeEqual = TypeUnifier.mayBeEqual(type3, other);
                    boolean bl = relative = typeChecker2.isSubtypeOf(type3, other) || typeChecker2.isSubtypeOf(other, type3);
                    if (!mayBeEqual && !relative) {
                        return null;
                    }
                    if (relative) continue;
                    relativeToAll = false;
                    break;
                }
                if (relativeToAll) {
                    return TypeUtils.makeNullableAsSpecified(type3, allNullable);
                }
            }
            for (KotlinType other : nullabilityStripped) {
                if (type3.equals(other) || !typeChecker2.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (KotlinType other : resultingTypes) {
                if (!typeChecker2.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            void var6_10;
            KotlinType kotlinType = FlexibleTypesKt.singleBestRepresentative(nullabilityStripped);
            if (kotlinType == null) {
                KotlinType kotlinType2 = UtilsKt.hackForTypeIntersector(nullabilityStripped);
            }
            if (var6_10 == null) {
                throw new AssertionError((Object)("Empty intersection for types " + types));
            }
            return TypeUtils.makeNullableAsSpecified((KotlinType)var6_10, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((KotlinType)resultingTypes.get(0), allNullable);
        }
        IntersectionTypeConstructor intersectionTypeConstructor = new IntersectionTypeConstructor(resultingTypes);
        return KotlinTypeFactory.simpleType(Annotations.Companion.getEMPTY(), intersectionTypeConstructor, Collections.emptyList(), allNullable, intersectionTypeConstructor.createScopeForKotlinType());
    }

    @NotNull
    public static KotlinType getUpperBoundsAsType(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/TypeIntersector", "getUpperBoundsAsType"));
        }
        List<KotlinType> upperBounds = descriptor2.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty: " + descriptor2;
        KotlinType upperBoundsAsType = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, upperBounds);
        KotlinType kotlinType = upperBoundsAsType != null ? upperBoundsAsType : DescriptorUtilsKt.getBuiltIns(descriptor2).getNothingType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeIntersector", "getUpperBoundsAsType"));
        }
        return kotlinType;
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull KotlinType type2, @NotNull KotlinType other) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(KotlinType withParameters2, KotlinType expected) {
            final HashMap parameters2 = new HashMap();
            Function1<TypeParameterUsage, Unit> processor2 = new Function1<TypeParameterUsage, Unit>(){

                public Unit invoke(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters2.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters2.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return Unit.INSTANCE;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters2, Variance.INVARIANT, processor2);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor2);
            ConstraintSystemBuilderImpl constraintSystem = new ConstraintSystemBuilderImpl();
            TypeSubstitutor substitutor3 = constraintSystem.registerTypeVariables(CallHandle.NONE.INSTANCE, parameters2.keySet(), false);
            constraintSystem.addSubtypeConstraint(withParameters2, substitutor3.substitute(expected, Variance.INVARIANT), ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.build().getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(KotlinType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                result2.invoke((Object)new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
            }
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result2);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }
}

