/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.KeyWithSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final Map<Object, KeyFMap> map = new THashMap(0);
    private Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = null;

    public static SlicedMapImpl create() {
        return new SlicedMapImpl();
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value2) {
        Object oldValue;
        if (!slice.check(key, value2)) {
            return;
        }
        KeyFMap holder = this.map.get(key);
        if (holder == null) {
            holder = KeyFMap.EMPTY_MAP;
        }
        KeyWithSlice<K, V, WritableSlice<K, V>> sliceKey = slice.getKey();
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (rewritePolicy.rewriteProcessingNeeded(key) && (oldValue = holder.get(sliceKey)) != null && !rewritePolicy.processRewrite(slice, key, oldValue, value2)) {
            return;
        }
        if (slice.isCollective()) {
            if (this.collectiveSliceKeys == null) {
                this.collectiveSliceKeys = ArrayListMultimap.create();
            }
            this.collectiveSliceKeys.put(slice, key);
        }
        this.map.put(key, holder.plus(sliceKey, value2));
        slice.afterPut(this, key, value2);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.collectiveSliceKeys = null;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        KeyFMap holder = this.map.get(key);
        Object value2 = holder == null ? null : holder.get(slice.getKey());
        return (V)slice.computeValue(this, key, value2, value2 == null);
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        if (this.collectiveSliceKeys == null) {
            return Collections.emptyList();
        }
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public void forEach(@NotNull Function3<WritableSlice, Object, Object, Void> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "forEach"));
        }
        for (Map.Entry<Object, KeyFMap> entry : this.map.entrySet()) {
            Object key = entry.getKey();
            KeyFMap holder = entry.getValue();
            if (holder == null) continue;
            for (Key sliceKey : holder.getKeys()) {
                Object value2 = holder.get(sliceKey);
                f.invoke((Object)((AbstractWritableSlice)sliceKey).getSlice(), key, value2);
            }
        }
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Object, KeyFMap> entry : this.map.entrySet()) {
            KeyFMap holder = entry.getValue();
            Object value2 = holder.get(slice.getKey());
            if (value2 == null) continue;
            builder.put(entry.getKey(), value2);
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        return immutableMap;
    }
}

