/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"getUnboxedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "kotlin-compiler"})
public final class BoxedBasicValueKt {
    @NotNull
    public static final Type getUnboxedType(@NotNull Type boxedType) {
        Intrinsics.checkParameterIsNotNull(boxedType, "boxedType");
        Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE)) {
            Type type2 = AsmTypes.JAVA_CLASS_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type2, "AsmTypes.JAVA_CLASS_TYPE");
            return type2;
        }
        throw (Throwable)new IllegalArgumentException("Expected primitive type wrapper or KClass, got: " + boxedType);
    }
}

